/***************************************************************************
                          kfactoryimpl.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.6 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include "kfactoryimpl.h"

KFactoryImpl::KFactoryImpl * KFactoryImpl::_factory = 0;

KFactoryImpl::KFactoryImpl() 
{
   objDict.setAutoDelete(true);
   typDict.setAutoDelete(true);
}

KFactoryImpl::~KFactoryImpl() 
{
   kdDebug(D_INI) << "factory: destroy" << endl;
}

KFactoryImpl * KFactoryImpl::factory() 
{
   if (_factory == 0)
      _factory = new KFactoryImpl();
   return _factory;
}

KObjectImpl * KFactoryImpl::createObject(int type) 
{
   KObjectImpl * proto = prototype(type);
   kdFatal(proto == 0, D_INI) << "factory: unknown prototype " << type << endl;
   kdDebug(D_INI) << "factory: create obj " << proto->type() << ":" << proto->typeStr() << endl;
   KObjectImpl *obj = proto->clone();
   return obj;
}

KObjectImpl * KFactoryImpl::prototype(int type) 
{ 
   return objDict[type]; 
}

void KFactoryImpl::addPrototype(int type, const KObjectImpl *obj, 
				const char *typeStr) 
{
   kdDebug(D_INI) << "factory: add proto " << type << " " << typeStr << endl;
   if (objDict[type] != 0)
      /* throw */ 
      Error("factory", QString("type %1, %2 duplicate").arg(type).arg(typeStr));
   objDict.insert(type, obj);
   typDict.insert(type, typeStr);
}

QString KFactoryImpl::typeStr(int type) 
{
   kdError(typDict[type] == 0, D_INI) << "factory: unknown type " << type << endl;
   return QString(typDict[type]);
}

QString KFactoryImpl::docId(int type) 
{
   return (objDict[type])->docId();
}

IntList KFactoryImpl::typeList(int type) 
{
   IntList lst;
   for (ObjDictIterator i(objDict); i.current() != 0; ++i)
      if (i.current()->type() & type)
	 lst += i.current()->type();
   return lst;
}
