/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PROCESSLISTVIEWITEM_H
#define PROCESSLISTVIEWITEM_H

#include <qlistview.h>
#include <qstring.h>
#include <qobject.h>

class ProcessController;

class ProcessListViewItem : public QObject, public QListViewItem
{
	Q_OBJECT
public:
  
	ProcessListViewItem( QListView * parent );
	ProcessListViewItem( QListViewItem * parent );
	ProcessListViewItem( QListView * parent, QListViewItem * after );
	ProcessListViewItem( QListViewItem * parent, QListViewItem * after );
	
	ProcessListViewItem( QListView * parent,
			QString,     QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	ProcessListViewItem( QListViewItem * parent,
			QString,     QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	
	ProcessListViewItem( QListView * parent, QListViewItem * after,
			QString,     QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	ProcessListViewItem( QListViewItem * parent, QListViewItem * after,
			QString,     QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );

	~ProcessListViewItem();
	
	ProcessController * getProcessController();
	
private:
	ProcessController * myProcessController;
};

#endif
