/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log: ttime.c,v $
 *	Revision 6.2  1999/06/12 18:04:33  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 19:41:37  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:07:15  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:35:11  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:35:26  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:08:26  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  93/07/21  21:59:50  gdburns
 * Remove SUCCESS.
 * Don't panic.
 * 
 * Revision 2.2  92/04/30  11:55:01  trillium
 * Ohio Release
 * 
 * Revision 2.1  91/03/20  13:36:00  gdburns
 * Ohio Release
 *
 *	Function:	- returns the contents of a system timer
 *			  expressed in seconds.
 *			- used primarily for recording elapsed 
 *			  time in the user code, in a portable
 *			  manner
 *			- The resolution is not guaranteed, as it
 *			  depends on the underlying hardware,
 *			  but the units (seconds) are
 *			  guaranteed.
 *			- This code is for OTB and uses the 
 *			  Unix(tm) timing support.
 *			- based on Trollius 2.0, Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 */

#include <sys/time.h>
#include <typical.h>

/*
 * external variables
 */
extern int	errno;

/*
 * ttime() returns the contents of the system timer (a measure
 * of time since an arbitrary but fixed point in time) expressed
 * in seconds. 
 */

double
ttime()

{
	struct	timeval	now;
	double		sec;
/*
 * Get the system time.
 */
	if (gettimeofday(&now, (struct timezone *) 0)) {
		return(0);
	}
/*
 * Return time in seconds.
 */
	sec = (double) now.tv_sec + (double) now.tv_usec / 1000000;
	return(sec);
}
