/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tgetconts_f.c,v 1.1 1999/09/02 01:34:34 prijks Exp $
 *
 *	Function:	- MPI_Type_get_contents F77 wrapper
 */

#include <errno.h>
#include <stdlib.h>

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>


void 
mpi_type_get_contents_(t, ni, na, nd, is, as, ds, ierr)

int			*t, *ni, *na, *nd, *is, *ds, *ierr;
MPI_Aint		*as;

{
	MPI_Datatype	*dtypes;
	int		i;

	dtypes = (MPI_Datatype *) malloc(*nd * sizeof(MPI_Datatype));
	if (dtypes == 0) {
		lam_setfunc_m(BLKMPITGETCONT);
		*ierr = lam_errfunc(MPI_COMM_WORLD, BLKMPITGETCONT,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr = MPI_Type_get_contents(GETHDL(*t), *ni, *na, 
					*nd, is, as, dtypes);
	if (*ierr != MPI_SUCCESS) return;

	for (i = 0; i < *nd; i++) {
		if (dtypes[i]->dt_f77handle != -1) {
			ds[i] = dtypes[i]->dt_f77handle;
		} else {
			if (lam_F_make_hdl(&ds[i], ierr, 
						dtypes[i], BLKMPITGETCONT)) {
				dtypes[i]->dt_f77handle = ds[i];
			} else {
				return;
			}
		}
	}

	free((char *) dtypes);
}

