/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infodup.c,v 6.3 1999/05/25 22:08:00 kmeyer1 Exp $
 *
 *	Function:	- duplicate an info object
 *	Accepts:	- info
 *			- duplicate info (in-out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Info_dup(info, newinfo)

MPI_Info		info;
MPI_Info		*newinfo;

{
	struct _infoent	*p;			/* key/value pair */
	int		err;			/* error code */
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPIINFODUP);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODUP,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	err = MPI_Info_create(newinfo);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFODUP, err));
	}
/*
 * Duplicate all the entries.
 */
	for (p = al_top(info->info_list); p; p = al_next(info->info_list, p)) {

		err = MPI_Info_set(*newinfo, p->ie_key, p->ie_value);
		if (err != MPI_SUCCESS) {
			return(lam_errfunc(MPI_COMM_WORLD,
						BLKMPIINFODUP, err));
		}
	}

	lam_resetfunc(BLKMPIINFODUP);
	return(MPI_SUCCESS);
}
