/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: pack.c,v 6.3 1999/05/25 22:08:11 kmeyer1 Exp $
 *
 *	Function:	- pack from data buffer
 *	Accepts:	- data buffer
 *			- data count
 *			- data type
 *			- packing buffer
 *			- packing buffer size
 *			- packing buffer position (in-out)
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Pack(buf, count, dtype, packbuf, packsize, packpos, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
void			*packbuf;
int			packsize;
int			*packpos;
MPI_Comm		comm;

{
	int		size;
	char		*p;

	lam_initerr();
	lam_setfunc(BLKMPIPACK);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIPACK, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (dtype == MPI_DATATYPE_NULL || (!dtype->dt_commit)) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((packsize < 0) || (packpos == 0)) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((*packpos < 0) || ((*packpos >= packsize) && (packsize > 0))) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((packsize > 0) && (packbuf == 0)) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_BUFFER, 0)));
	}
/*
 * Pack the data.
 */
	p = ((char *) packbuf) + *packpos;
	size = packsize - *packpos;

	size = lam_pack((char *) buf, count, dtype, p, size);

	if (size < 0) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_TRUNCATE, 0)));
	}

	*packpos += size;

	lam_resetfunc(BLKMPIPACK);
	return(MPI_SUCCESS);
}
