/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	SBD/JRV
 *
 *	$Id: tfprint.c,v 6.8 1999/07/28 00:32:08 jsquyres Exp $
 *
 *	Function:	- prints on stdout
 *	Accepts:	- format string
 *			- variable number of items to print
 *	Returns:	- the number of printed characters, or EOF if error
 */

#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <lam_config.h>
#include <laminternal.h>
#include <tstdio.h>

#if LAM_WANT_PROTOS
int
tprintf(const char *format, ...)
#else
int
tprintf(format, va_alist)

char			*format;
va_dcl
#endif

{
	char		*storep	= 0;
	TFILE		*fp	= tstdout;
	int		count;
	va_list		arglist;

#if __STDC__
	va_start(arglist, format);
#else
	va_start(arglist);
#endif
	count = _fmt(fp, storep, format, arglist);
	va_end(arglist);
	return(count);
}


/*
 *	tfprintf
 *
 *	Function:	- prints to file pointed to by fp
 *	Accepts:	- file pointer
 *			- format string
 *			- variable number of items to print
 *	Returns:	- the number of printed characters, of EOF if error
 */
#if LAM_WANT_PROTOS
int
tfprintf(TFILE *fp, const char *format, ...)
#else
int
tfprintf(fp, format, va_alist)

TFILE			*fp;
char			*format;
va_dcl

#endif

{
	char		*storep	= 0;
	int		count;
	va_list		arglist;

#if __STDC__
	va_start(arglist, format);
#else
	va_start(arglist);
#endif
	count = _fmt(fp, storep, format, arglist);
	va_end(arglist);
	return(count);
}


/*
 *	tsprintf
 *
 *	Function:	- prints memory location pointed to by storep
 *	Accepts:	- char pointer to destination
 *			- format string
 *			- variable number of items to format
 *	Returns:	- char pointer to destination
 */	
#if LAM_WANT_PROTOS
char *
tsprintf(char *storep, const char *format, ...)
#else
char *
tsprintf(storep, format, va_alist)

char			*storep;
char			*format;
va_dcl

#endif

{
	TFILE		*fp = 0;
	int		count;
	va_list		arglist;

#if __STDC__
	va_start(arglist, format);
#else
	va_start(arglist);
#endif
	count = _fmt(fp, storep, format, arglist);
	va_end(arglist);
	
	return(storep + count);
}


/*
 *	tvprintf
 *
 *	Function:	- same as printf(), but this takes a va_list
 *	Accepts:	- format string
 *			- variable number of items to format in a va_list
 *	Returns:	- the number of printed characters, of EOF if error
 */
#if LAM_WANT_PROTOS
int
tvprintf(const char *format, ...)
#else
int
tvprintf(format, va_alist)

char			*format;
va_dcl

#endif

{
	char		*storep	= 0;
	TFILE		*fp	= tstdout;
	int		count;
	va_list		ap;

#if __STDC__
	va_start(ap, format);
#else
	va_start(ap);
#endif
	count = _fmt(fp, storep, format, ap);
	va_end(ap);
	return(count);
}


/*
 *      tvfprintf
 *
 *	Function:	- same as fprintf(), but this takes a va_list
 *	Accepts:	- file pointer
 *			- format string
 *			- variable number of items to format in a va_list
 *	Returns:	- the number of printed characters, of EOF if error
 */
#if LAM_WANT_PROTOS
int
tvfprintf(TFILE *fp, const char *format, ...)
#else
int
tvfprintf(fp, format, va_alist)

TFILE			*fp;
char			*format;
va_dcl

#endif

{
	char		*storep	= 0;
	int		count;
	va_list		ap;

#if __STDC__
	va_start(ap, format);
#endif
	count = _fmt(fp, storep, format, ap);
#if __STDC__
	va_end(ap);
#endif
	return(count);
}


/*
 *	tvsprintf
 *
 *	Function:	- same as sprintf, but takes a va_list
 *	Accepts:	- char pointer to destination
 *			- format string
 *			- variable number of items to format in a va_list
 *	Returns:	- char pointer to destination
 */
#if LAM_WANT_PROTOS
char *
tvsprintf(char *storep, const char *format, ...)
#else
char *
tvsprintf(storep, format, va_alist)

char			*storep;
char			*format;
va_dcl

#endif

{
	TFILE		*fp = 0;
	int		count;
	va_list		ap;

#if __STDC__
	va_start(ap, format);
#endif
	count = _fmt(fp, storep, format, ap);
#if __STDC__
	va_end(ap);
#endif
	return(storep + count);
}
