/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *
 *	$Id: tsetbuf.c,v 6.3 1999/05/27 20:07:09 kmeyer1 Exp $
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <tstdio.h>

void
tsetbuffer(fp, buf, size)
	TFILE *fp;
	unsigned char *buf;
	int size;
{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) return;
	fp->_cnt = 0;
	fp->_ptr = buf;
	if ((fp->_base = buf))		/* assignment intentional */
	{
		fp->_bsiz = size;
	}
	else
	{
		fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF | _TIOMYBUF);
		fp->_flag |= _TIONBF;
		fp->_bsiz = 0;
	}
}

void
tsetbuf(fp, buf)

TFILE		*fp;
unsigned char	*buf;

{
	tsetbuffer(fp, buf, TBUFSIZ);
}

int
tsetvbuf(fp, buf, type, size)

TFILE		*fp;
unsigned char	*buf;
int		type;
int		size;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	if ((type != _TIOFBF) || (type != _TIOLBF) || (type != _TIONBF)) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= type;

	if (buf) {

		if (size <= 0) {
			return(EOF);
		}

		fp->_base = buf;
		fp->_ptr = buf;
		fp->_bsiz = size;
		fp->_cnt = 0;
	}

	return(0);
}

int
tsetlinebuf(fp)

TFILE		*fp;

{
	if (! (fp->_flag & (_TIOREAD | _TIOWRT))) {
		return(EOF);
	}

	fp->_flag &= ~(_TIOFBF | _TIOLBF | _TIONBF);
	fp->_flag |= _TIOLBF;
	return(0);
}
