BEGIN {require 'mbenclib.pl';}

my $mbr = 0;

foreach (qw(id names flag G converters
	    decmap_spec default_decoder encmap_spec
	    endecoder_spec c h)) {
  my $i = $mbr++;

  *{'CES::' . $_} = sub {$_[0]->[$i];};
  *{'CES::set_' . $_} = sub {$_[0]->[$i] = $_[1];};
  *{'CES::add_' . $_} = sub {$_[0]->[$i] .= $_[1];};
}

my @iso8859_fc = (0x41,0x42,0x43,0x44,0x4C,0x47,0x46,0x48,0x4D,0x56);

my @mb_ces =
  (

   ['ASCII',
    [qw(us-ascii ascii)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    undef,
    [decmap_CLGL],
    ],

   ['GB2312',
    [qw(gb2312 cn-gb)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_94x94)], [MB_ASCII_FC, 0x41]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x41),&decmap_94x94(qw(1 R))],
     ],
    ],

   ['GB_ISO_IR_165',
    [qw(cn-gb-isoir165)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_94x94)], [MB_ASCII_FC, 0x45]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x45),&decmap_94x94(qw(1 R))],
     ],
    ],

   ['CN',
    [qw(iso-2022-cn)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     (map {[&decmap_94x94_range($_),&decmap_94x94(qw(1 L))]} (0x41,0x47)),
     [&decmap_94x94_range(0x48),&decmap_94x94(qw(2 SL))],
     ],
    ],

   ['CN_EXT',
    [qw(iso-2022-cn-ext)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     (map {[&decmap_94x94_range($_),&decmap_94x94(qw(1 L))]} (0x41,0x45,0x47)),
     [&decmap_94x94_range(0x48),&decmap_94x94(qw(2 SL))],
     (map {[&decmap_94x94_range($_),&decmap_94x94(qw(3 SL))]} (0x49..0x4D)),
     ],
    ],

   ['EUC_JP',
    [qw(euc-jp x-euc-jp ujis jis8)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_94x94 mb_94 mb_94x94)], [MB_ASCII_FC, 0x42, 0x49, 0x44]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x42),&decmap_94x94(qw(1 R))],
     [&decmap_94_range(0x49),&decmap_94(qw(2 SR))],
     [&decmap_94x94_range(0x44),&decmap_94x94(qw(3 SR))],
     ],
    ],

   ['EUC_JISX0213',
    [qw(euc-jisx0213 x-euc-jisx0213)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_94x94 mb_94 mb_94x94)], [MB_ASCII_FC, 0x4F, 0x49, 0x50]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x4F),&decmap_94x94(qw(1 R))],
     [&decmap_94_range(0x49),&decmap_94(qw(2 SR))],
     [&decmap_94x94_range(0x50),&decmap_94x94(qw(3 SR))],
     ],
    ],

   ['ISO2022JP',
    [qw(iso-2022-jp jis jis7)],
    [qw(mb_flag_plus MB_FLAG_ASCIIATCTL)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94_range(0x4A),&decmap_94(qw(0 L))],
     [&decmap_94x94_range(0x40),&decmap_94x94(qw(0 L))],
     [&decmap_94x94_range(0x42),&decmap_94x94(qw(0 L))],
     ],
    ],

   ['ISO2022JP2',
    [qw(iso-2022-jp-2)],
    [qw(mb_flag_plus MB_FLAG_ASCIIATCTL)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94_range(0x4A),&decmap_94(qw(0 L))],
     [&decmap_94x94_range(0x40),&decmap_94x94(qw(0 L))],
     [&decmap_94x94_range(0x42),&decmap_94x94(qw(0 L))],
     [&decmap_94x94_range(0x44),&decmap_94x94(qw(0 L))],
     ],
    ],

   ['ISO2022JP3',
    [qw(iso-2022-jp-3)],
    [qw(mb_flag_plus MB_FLAG_ASCIIATCTL)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94_range(0x4A),&decmap_94(qw(0 L))],
     [&decmap_94x94_range(0x4F),&decmap_94x94(qw(0 L))],
     [&decmap_94x94_range(0x44),&decmap_94x94(qw(0 L))],
     [&decmap_94x94_range(0x50),&decmap_94x94(qw(0 L))],
     ],
    ],

   ['EUC_KR',
    [qw(euc-kr x-euc-kr)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_94x94)], [MB_ASCII_FC, 0x43]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x43),&decmap_94x94(qw(1 R))],
     ],
    ],

   ['ISO2022KR',
    [qw(iso-2022-kr)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_Gn), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_94x94_range(0x43),&decmap_94x94(qw(0 L))],
     ],
    ],

   do {
     map {
       ['ISO8859_' . $_,
	['iso-8859-' . $_],
	[qw(mb_flag_plus 0)],
	[qw(mb_G0 mb_G1), [qw(mb_94 mb_96)], [MB_ASCII_FC, $iso8859_fc[$_-1]]],
	[qw(mb_conv_to_%s)],
	[decmap_CLGL,
	 [&decmap_96_range($iso8859_fc[$_-1]),&decmap_96(qw(1 R))],
	 ],
	]
	} (1 .. 10);
   },

   ['XCTEXT',
    [qw(x-ctext)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_96)], [MB_ASCII_FC, 0x41]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     (map {[&decmap_94_range($_), &decmap_94(qw(1 R))]} (0x49, 0x4A)),
     (map {[&decmap_96_range($iso8859_fc[$_-1]),&decmap_96(qw(1 R))]} (1 .. 10)),
     (map {[&decmap_94x94_range($_), &decmap_94x94(qw(0 L))]} (0x40 .. 0x44)), 
     ],
    ],

   ['UTF8',
    [qw(utf-8)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv1_to_ucs)],
    [qw(CLGL %s)],
    ],

   ['UTF16',
    [qw(utf-16)],
    [qw(mb_flag_plus 0)],
    [qw(mb_GN mb_%s), [], []],
    [qw(mb_conv1_to_ucs)],
    [[0,0x10FFFF,qw(mb_utf16_decoder NULL 0 NULL)]],
    ],

   ['UTF16BE',
    [qw(utf-16be)],
    [qw(mb_flag_plus 0)],
    [qw(mb_%s mb_%s), [], []],
    [qw(mb_conv1_to_ucs)],
    [[0,0x10FFFF,qw(mb_utf16_decoder NULL 0 NULL)]],
    ],

   ['UTF16LE',
    [qw(utf-16le)],
    [qw(mb_flag_plus 0)],
    [qw(mb_%s mb_%s), [], []],
    [qw(mb_conv1_to_ucs)],
    [[0,0x10FFFF,qw(mb_utf16le_decoder NULL 0 NULL)]],
    ],

   ['MOEINTERNAL',
    [qw(x-moe-internal)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    undef,
    [qw(CLGL %s)],
    ],

   ['KOI8R',
    [qw(koi8-r)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [mb_94], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_SBC, '%s', +{'' => 0}, [[0x80, 0xFF],[]]],
    ],

   ['KOI8U',
    [qw(koi8-u)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_SBC, '%s', +{'' => 0}, [[0x80, 0xFF],[]]],
    ],

   (map {
     ['WIN125' . $_,
      ['windows-125' . $_],
      [qw(mb_flag_plus 0)],
      [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
      [qw(mb_conv_to_%s)],
      [qw(CLGL %s)],
      undef,
      [qw(CL GL %s)],
      [mb_SBC, '%s', +{'' => 0}, [[0x80, 0xFF],[]]],
      ]
      } (0 .. 8)),

   ['SJIS',
    [qw(shift_jis x-sjis sjis shift-jis)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [undef, '%s', +{('k' => MB_WORD_94_ENC(0x49,0),
		     'j' => MB_WORD_94x94_ENC(0x42,0*94),
		     )},
     [[0xA1,0xDF],[],'k'],
     [[0x81,0x9F,0xE0,0xEF],[],[[0x40,0x7E,0x80,0xFC],[],'j']],
     ],
    ],

   ['SJIS0213',
    [qw(shift_jisx0213 shift-jisx0213)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [undef, '%s', +{('k' => MB_WORD_94_ENC(0x49,0),
		     'p1' => MB_WORD_94x94_ENC(0x4F,0*94),
		     'p2r1' => MB_WORD_94x94_ENC(0x50,0*94),
		     'p2r3' => MB_WORD_94x94_ENC(0x50,2*94),
		     'p2r5' => MB_WORD_94x94_ENC(0x50,4*94),
		     'p2r8' => MB_WORD_94x94_ENC(0x50,7*94),
		     'p2r12' => MB_WORD_94x94_ENC(0x50,11*94),
		     'p2r13' => MB_WORD_94x94_ENC(0x50,12*94),
		     'p2r15' => MB_WORD_94x94_ENC(0x50,14*94),
		     'p2r78' => MB_WORD_94x94_ENC(0x50,77*94),
		     'p2r79' => MB_WORD_94x94_ENC(0x50,78*94),
		     )},
     [[0xA1,0xDF],[],'k'],
     [[0x81,0x9F,0xE0,0xEF],[],[[0x40,0x7E,0x80,0xFC],[],'p1']],
     [[0xF0,0xF0],[],[[0x40,0x7E,0x80,0x9E],[],'p2r1'],[[0x9F,0xFC],[],'p2r8']],
     [[0xF1,0xF1],[],[[0x40,0x7E,0x80,0xFC],[],'p2r3']],
     [[0xF2,0xF2],[],[[0x40,0x7E,0x80,0x9E],[],'p2r5'],[[0x9F,0xFC],[],'p2r12']],
     [[0xF3,0xF3],[],[[0x40,0x7E,0x80,0xFC],[],'p2r13']],
     [[0xF4,0xF4],[],[[0x40,0x7E,0x80,0x9E],[],'p2r15'],[[0x9F,0xFC],[],'p2r78']],
     [[0xF5,0xFC],[],[[0x40,0x7E,0x80,0xFC],[],'p2r79']],
     ],
    ],

   ['BIG5',
    [qw(big5 cn-big5)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_DBC, '%s', +{'' => 0},
     [[0xA1,0xFE],[],[[0x40,0x7E,0xA1,0xFE],[]]],
     ],
    ],

   ['JOHAB',
    [qw(x-johab)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_DBC, '%s', +{('' => 0,
		      'ksx0' => MB_WORD_94x94_ENC(0x43,(0x21-0x21)*94+0x21-0x21),
		      'ksx1' => MB_WORD_94x94_ENC(0x43,(0x23-0x21)*94+0x21-0x21),
		      'ksx2' => MB_WORD_94x94_ENC(0x43,(0x24-0x21)*94+0x54-0x21),
		      'ksx3' => MB_WORD_94x94_ENC(0x43,(0x25-0x21)*94+0x21-0x21),
		      'ksx4' => MB_WORD_94x94_ENC(0x43,(0x4A-0x21)*94+0x21-0x21),
		      )},
     [[0x84,0xD3],[],[[0x41,0x7E,0x81,0xFE],[]]],
     [[0xD8,0xD8],[],[[0x31,0x7E,0x91,0xFE],[]]],
     [[0xD9,0xD9],[],[[0x31,0x7E,0x91,0xFE],[],'ksx0']],
     [[0xDA,0xDA],[],
      [[0x31,0x7E,0x91,0xA0],[],'ksx1'],
      [[0xA1,0xD3],[]],
      [[0xD4,0xFE],[],'ksx2'],
      ],
     [[0xDB,0xDE],[],[[0x31,0x7E,0x91,0xFE],[],'ksx3']],
     [[0xE0,0xF9],[],[[0x31,0x7E,0x91,0xFE],[],'ksx4']],
     ],
    ],

   ['UHANG',
    [qw(x-unified-hangle x-uhc)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_DBC, '%s', +{'' => 0, 'ksx' => MB_WORD_94x94_ENC(0x43,0*94)},
     [[0x81,0xA0],[],[[0x41,0x5A,0x61,0x7A,0x81,0xFE],[]]],
     [[0xA1,0xC6],[],[[0x41,0x5A,0x61,0x7A,0x81,0xA0],[]],[[0xA1,0xFE],[],'ksx']],
     [[0xC7,0xFE],[],[[0xA1,0xFE],[],'ksx']],
     ],
    ],

   ['EUC_TW',			# 0: Identifier in C and Perl program,
    [qw(x-euc-tw euc-tw)],	# 1: charset names,
    [qw(mb_flag_plus 0)],	# 2: flag,
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]], # 3: initial value of the member G,
    [qw(mb_conv_to_%s)],	# 4: converter names,
    [qw(CLGL %s)],		# 5: decoder map,
    undef,			# 6: default decoder name,
    [qw(CL GL %s)], # encoder spec,
    [mb_DBC, '%s',		# 8: argument passed to &make_named_encoder,
     +{'' => 0, 'p1' => MB_WORD_94x94_ENC(0x47,0*94), 'p1_7' => MB_WORD_94x94_ENC(0x47,0*94)},
     [[0xA1,0xFE],[],[[0xA1,0xFE],[],'p1']],
     [[0x8E,0x8E],[],
      map {
	[[0xA1+$_-1,0xA1+$_-1],[],[[0xA1,0xFE],[],[[0xA1,0xFE],[],$_ <= 7 ? qw(p1_7) : ()]]],
      } (1 .. 16)
      ],
     ],
    ],

   ['EUC_JISX0213_PACKED',
    [qw(x-euc-jisx0213-packed)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [undef, '%s', +{('p1' => MB_WORD_94x94_ENC(0x4F,0),
		     'k' => MB_WORD_94_ENC(0x49,0),
		     'p2r1' => MB_WORD_94x94_ENC(0x50,0*94),
		     'p2r2' => MB_WORD_94x94_ENC(0x44,1*94),
		     'p2r3' => MB_WORD_94x94_ENC(0x50,2*94), # upto r5
		     'p2r6' => MB_WORD_94x94_ENC(0x44,5*94), # upto r7
		     'p2r8' => MB_WORD_94x94_ENC(0x50,7*94),
		     'p2r9' => MB_WORD_94x94_ENC(0x44,8*94), # upto r11
		     'p2r12' => MB_WORD_94x94_ENC(0x50,11*94), # upto r15
		     'p2r16' => MB_WORD_94x94_ENC(0x44,15*94), # upto r77
		     'p2r78' => MB_WORD_94x94_ENC(0x50,77*94), # upto r86
		     'p2r87' => MB_WORD_94x94_ENC(0x44,86*94), # upto r94
		     )},
     [[0xA1,0xFE],[],[[0xA1,0xFE],[],'p1']],
     [[0x8E,0x8E],[],[[0xA1,0xDF],[],'k']],
     [[0x8F,0x8F],[],
      [[0xA1,0xA1],[],[[0xA1,0xFE],[],'p2r1']],
      [[0xA2,0xA2],[],[[0xA1,0xFE],[],'p2r2']],
      [[0xA3,0xA5],[],[[0xA1,0xFE],[],'p2r3']],
      [[0xA6,0xA7],[],[[0xA1,0xFE],[],'p2r6']],
      [[0xA8,0xA8],[],[[0xA1,0xFE],[],'p2r8']],
      [[0xA9,0xAB],[],[[0xA1,0xFE],[],'p2r9']],
      [[0xAC,0xAF],[],[[0xA1,0xFE],[],'p2r12']],
      [[0xB0,0xED],[],[[0xA1,0xFE],[],'p2r16']],
      [[0xEE,0xF6],[],[[0xA1,0xFE],[],'p2r78']],
      [[0xF7,0xFE],[],[[0xA1,0xFE],[],'p2r87']],
      ],
     ],
    ],

   ['GBK',
    [qw(x-gbk)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_DBC, '%s', +{('' => 0,
		      'gb2312' => MB_WORD_94x94_ENC(0x41,0),
		      )},
     [[0x81,0xA0],[],[[0x40,0x7E,0x80,0xFE],[]]],
     [[0xA1,0xFE],[],[[0x40,0x7E,0x80,0xA0],[]],[[0xA1,0xFE],[],'gb2312']],
     ],
    ],

   ['GBK2K',
    [qw(x-gb-18030-2000 x-gbk2k)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_%s), [qw(mb_94)], [MB_ASCII_FC]],
    [qw(mb_conv_to_%s)],
    [qw(CLGL %s)],
    undef,
    [qw(CL GL %s)],
    [mb_DBC, '%s', +{('' => 0,
		      'gb2312' => MB_WORD_94x94_ENC(0x41,0),
		      'gbk' => '&MB_GBK_ENC(0x81,0x40)',
		      'u1' => 0x0452,
		      'u2' => 0x2643,
		      'u3' => 0x361B,
		      'u4' => 0x3CE1,
		      'u5' => 0x4160,
		      'u6' => 0x44D7,
		      'u7' => 0x478E,
		      'u8' => 0x49B8,
		      'u9' => 0x9FA6,
		      'ua' => 0xE865,
		      'ub' => 0xFA2A,
		      'uc' => 0xFFE6,
		      'ud' => 0x10000,
		      )},
     [[0x81,0x81],[],
      [[0x30,0x30],[],
       [[0x81,0xD2],[],[[0x30,0x39],[]]],
       [[0xD3,0xFE],[],[[0x30,0x39],[]],'u1'],
       ],
      [[0x31,0x35],[],[[0x81,0xFE],[],[[0x30,0x39],[],'u1']]],
      [[0x36,0x36],[],
       [[0x81,0xA4],[],[[0x30,0x39],[],'u1']],
       [[0xA5,0xA5],[],[[0x30,0x31],[],'u1'],[[0x32,0x39],[]]],
       [[0xA6,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x37,0x37],[],
       [[0x81,0xA7],[],[[0x30,0x39],[]]],
       [[0xA8,0xA8],[],[[0x30,0x38],[]],[[0x39,0x39],[],'u2']],
       [[0xA9,0xFE],[],[[0x30,0x39],[],'u2']],
       ],
      [[0x38,0x38],[],
       [[0x81,0xFC],[],[[0x30,0x39],[],'u2']],
       [[0xFD,0xFD],[],[[0x30,0x38],[],'u2'],[[0x39,0x39],[]]],
       [[0xFE,0xFE],[],[[0x30,0x39],[]]]],
      [[0x39,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[]]]],
      [[0x40,0xFE],[]],
      ],
     [[0x82,0x82],[],
      [[0x30,0x30],[],
       [[0x81,0xA5],[],[[0x30,0x39],[]]],
       [[0xA6,0xA6],[],[[0x30,0x32],[]],[[0x33,0x39],[],'u3']],
       [[0xA7,0xF1],[],[[0x30,0x39],[],'u3']],
       [[0xF2,0xF2],[],[[0x30,0x37],[],'u3'],[[0x38,0x39],[]]],
       [[0xF3,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x31,0x31],[],
       [[0x81,0xD3],[],[[0x30,0x39],[]]],
       [[0xD4,0xD4],[],[[0x30,0x37],[]],[[0x38,0x39],[],'u4']],
       [[0xD5,0xFE],[],[[0x30,0x39],[],'u4']],
       ],
      [[0x32,0x32],[],
       [[0x81,0xAE],[],[[0x30,0x39],[],'u4']],
       [[0xAF,0xAF],[],[[0x30,0x32],[],'u4'],[[0x33,0x39],[]]],
       [[0xB0,0xC8],[],[[0x30,0x39],[]]],
       [[0xC9,0xC9],[],[[0x30,0x36],[]],[[0x37,0x39],[],'u5']],
       [[0xCA,0xF7],[],[[0x30,0x39],[],'u5']],
       [[0xF8,0xF8],[],[[0x30,0x37],[],'u5'],[[0x38,0x39],[]]],
       [[0xF9,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x33,0x33],[],
       [[0x81,0xA2],[],[[0x30,0x39],[]]],
       [[0xA3,0xA3],[],[[0x30,0x38],[]],[[0x39,0x39],[],'u6']],
       [[0xA4,0xC8],[],[[0x30,0x39],[],'u6']],
       [[0xC9,0xC9],[],[[0x30,0x31],[],'u6'],[[0x32,0x39],[]]],
       [[0xCA,0xE7],[],[[0x30,0x39],[]]],
       [[0xE8,0xE8],[],[[0x30,0x37],[]],[[0x38,0x39],[],'u7']],
       [[0xE9,0xFE],[],[[0x30,0x39],[],'u7']],
       ],
      [[0x34,0x34],[],
       [[0x81,0x95],[],[[0x30,0x39],[],'u7']],
       [[0x96,0x96],[],[[0x30,0x38],[],'u7'],[[0x39,0x39],[]]],
       [[0x97,0xA0],[],[[0x30,0x39],[]]],
       [[0xA1,0xA1],[],[[0x30,0x30],[]],[[0x31,0x39],[],'u8']],
       [[0xA2,0xE6],[],[[0x30,0x39],[],'u8']],
       [[0xE7,0xE7],[],[[0x30,0x33],[],'u8'],[[0x34,0x39],[]]],
       [[0xE8,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x35,0x35],[],
       [[0x81,0x8E],[],[[0x30,0x39],[]]],
       [[0x8F,0x8F],[],[[0x30,0x32],[]],[[0x33,0x39],[],'u9']],
       [[0x90,0xFE],[],[[0x30,0x39],[],'u9']],
       ],
      [[0x40,0xFE],[],'gbk'],
      ],
     [[0x83,0x83],[],
      [[0x30,0x35],[],[[0x81,0xFE],[],[[0x30,0x39],[],'u9']]],
      [[0x36,0x36],[],
       [[0x81,0xC6],[],[[0x30,0x39],[],'u9']],
       [[0xC7,0xC7],[],[[0x30,0x38],[],'u9'],[[0x39,0x39],[]]],
       [[0xC8,0xCF],[],[[0x30,0x39],[]]],
       [[0xD0,0xFE],[],[[0x30,0x39],[],'ua']],
       ],
      [[0x40,0xFE],[],'gbk'],
      ],
     [[0x84,0x84],[],
      [[0x30,0x30],[],
       [[0x81,0x84],[],[[0x30,0x39],[],'ua']],
       [[0x85,0x85],[],[[0x30,0x34],[],'ua'],[[0x35,0x39],[]]],
       [[0x86,0x9B],[],[[0x30,0x39],[]]],
       [[0x9C,0x9C],[],[[0x30,0x37],[]],[[0x38,0x39],[],'ub']],
       [[0x9D,0xFE],[],[[0x30,0x39],[],'ub']],
       ],
      [[0x31,0x31],[],
       [[0x81,0x84],[],[[0x30,0x39],[],'ub']],
       [[0x85,0x85],[],[[0x30,0x37],[],'ub'],[[0x38,0x39],[]]],
       [[0x86,0xA1],[],[[0x30,0x39],[]]],
       [[0xA2,0xA2],[],[[0x30,0x33],[]],[[0x34,0x39],[],'uc']],
       [[0xA3,0xA4],[],[[0x30,0x39],[],'uc']],
       [[0xA5,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x32,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[]]]],
      [[0x40,0xFE],[],'gbk'],
      ],
     [[0x85,0x8F],[],
      [[0x30,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[]]]],
      [[0x40,0xFE],[],'gbk'],
      ],
     [[0x90,0xA0],[],
      [[0x30,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[],'ud']]],
      [[0x40,0xFE],[],'gbk'],
      ],
     [[0xA1,0xE1],[],
      [[0x30,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[],'ud']]],
      [[0x40,0xA0],[],'gbk'],
      [[0xA1,0xFE],[],'gb2312'],
      ],
     [[0xE2,0xE2],[],
      [[0x30,0x31],[],[[0x81,0xFE],[],[[0x30,0x39],[],'ud']]],
      [[0x32,0x32],[],
       [[0x81,0x99],[],[[0x30,0x39],[],'ud']],
       [[0x9A,0x9A],[],[[0x30,0x35],[],'ud'],[[0x36,0x39],[]]],
       [[0x9B,0xFE],[],[[0x30,0x39],[]]],
       ],
      [[0x33,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[]]]],
      [[0x40,0xA0],[],'gbk'],
      [[0xA1,0xFE],[],'gb2312'],
      ],
     [[0xE3,0xFE],[],
      [[0x30,0x39],[],[[0x81,0xFE],[],[[0x30,0x39],[]]]],
      [[0x40,0xA0],[],'gbk'],
      [[0xA1,0xFE],[],'gb2312'],
      ],
     ],
    ],

   ['TIS620',
    [qw(tis-620 iso-8859-11)],
    [qw(mb_flag_plus 0)],
    [qw(mb_G0 mb_G1), [qw(mb_94 mb_96)], [MB_ASCII_FC, 0x54]],
    [qw(mb_conv_to_%s)],
    [decmap_CLGL,
     [&decmap_96_range($iso8859_fc[$_-1]),&decmap_96(qw(1 R))],
     ],
    ]

   );

my %mb_ces_by_id =
  map {
    my $ces = $_;

    bless $ces, 'CES';

    my $id = $ces->id;
    my $argv = $ces->endecoder_spec;

    if (defined($argv) && ref($argv) eq 'ARRAY') {
      &make_named_encoder($argv->[0], sprintf($argv->[1], $id), @{$argv}[2 .. $#$argv]);

      my ($c, $h) = &make_cm($id, &{'mb_' . $id . '_matrix'}, &{'mb_' . $id . '_destinations'});

      $ces->add_c($c);
      $ces->add_h($h);
    }

    ($id => $ces);
  } @mb_ces;

my %mb_ces_by_name = map {my $ces = $_; map {($_ => $ces)} @{$ces->names}} @mb_ces;

sub CES::by_id {$mb_ces_by_id{$_[1]};}
sub CES::by_name {$mb_ces_by_name{$_[1]};}
sub CES::all {@mb_ces;}

1;
