/* split.hh - split a line into words
 * Copyright 2007 Bas Wijnen <wijnen@debian.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SHEVEK_SPLIT_HH
#define SHEVEK_SPLIT_HH

#include <string>
#include <vector>

namespace shevek
{
	/// Split a string into words and retrieve them individually.
	class split : public std::vector <std::string>
	{
	public:
		/// Create a new split object, and optionally load it with data.
		split (std::string const &str = std::string ())
		{
			load (str);
		}
		/// Load new data into an existing split object.
		void load (std::string const &str, bool allow_empty = false, std::string const &delimiters = std::string (" \t\v\f\a\n\r\0", 8));
		/// Get a word from the split object.
		/** This differs from std::vector's method in that it returns an empty string if idx is out of range.
		 */
		std::string operator[] (unsigned idx) const
		{
			if (idx >= size ())
				return std::string ();
			return std::vector <std::string>::operator[] (idx);
		}
		/// Get a new split object containing only the last part of this one.
		split sub (unsigned from) const;
	};
}

#endif // defined (SHEVEK_SPLIT_HH)
