AC_DEFUN([AC_CHECK_HOSTTAG],dnl
[
# Guess the host type 
AC_CANONICAL_HOST
f77int="F77INT32"
case  $host_os in
   irix5.* | irix6.* | osf4.* | osf5.* | linux*  )

        linux64="true"
        expr "$host_os" : 'linux' >/dev/null && test ! x"$host_cpu" = x"x86_64" && linux64="false" 
	if test ! x"$linux64" = "xfalse" ; then
	  AC_MSG_CHECKING(for 64bits integers size in F77/F90)
	  AC_ARG_ENABLE(int64,
  			[  --enable-int64     use 64bits integers in F77/F90 (IRIX64 & OSF/1).])
	  case "X-$enable_int64" in
	    X-no)
	     AC_MSG_RESULT("disabled")
	     SUFFIXES="_32"
	     ;;
	    *)
	     AC_MSG_RESULT("enabled")
	     SUFFIXES=""
	     f77int="F77INT64"		
	     ;;
	  esac
	fi	
     ;;
   *)
     ;;
esac

case $host_os in
    linux*)
        test x"$linux64" = x"true" && \
          machine="PCLINUX64${SUFFIXES}" || \
	machine=PCLINUX
	;;
    hpux*)
	machine=HP9000
	;;
    aix4.*)
	machine=RS6000
	host_os_novers=aix4.x
	;;
    irix5.*)
	machine="IRIX64${SUFFIXES}"
	host_os_novers=irix5.x
	;;
    irix6.*)
	machine="IRIX64${SUFFIXES}"
	host_os_novers=irix6.x
	;;
    osf4.*)
	machine="OSF1${SUFFIXES}"
	host_os_novers=osf4.x
	;;
    osf5.*)
	machine="OSF1${SUFFIXES}"
	 host_os_novers=osf5.x
	 ;;
    solaris2.*)
	machine=SUN4SOL2
	 host_os_novers=solaris2.x
	 ;;
    uxpv*)
	machine=VPP5000
	 ;;
    *)
	machine=
	 host_os_novers=$host_os
	 ;;
esac

CPPFLAGS="$CPPFLAGS -D$machine -D$f77int -D_MESGERR_"

host_config="none"
for f in $host_cpu-$host_vendor-$host_os \
         $host_cpu-$host_vendor-$host_os_novers \
                         $host_vendor-$host_os \
         $host_vendor-$host_os_novers \
         $host_cpu-$host_os \
         $host_cpu-$host_os_novers \
         $host_cpu-$host_vendor \
                 $host_os \
                         $host_os_novers \
                         $host_vendor \
                         $host_cpu ; do
   AC_MSG_CHECKING(for config $f)
   if test -f "$srcdir/config/$f"; then
        host_config=$srcdir/config/$f
         AC_MSG_RESULT(found)
        break
   fi
   AC_MSG_RESULT(no)
done

])

