C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************

C       ******************************************************************************
C       * - Nom du fichier : test28.f
C       *
C       * - Description : lecture des maillages structures (grille cartesienne |
C       *                 grille de-structuree ) dans le fichier test27.med
C       *
C       *****************************************************************************
	program test28
C       
	implicit none
	include 'med.hf'
C       
C       
	integer       cret, fid,i,j
C       ** la dimension du maillage                         **
	integer       mdim,nind,nmaa,type,quoi,rep,typmaa
C       ** nom du maillage de longueur maxi MED_TAILLE_NOM  **
	character*32  maa
C       ** le nombre de noeuds                              **
	integer       nnoe 
C       ** table des coordonnees                            **
        real*8        coo(8)
	character*16  comp, comp2(2)
	character*16  unit, unit2(2)
	character*200 desc
        integer       strgri(2)
C       ** grille cartesienne                               **
	integer       axe
        real*8        indice(4)
	integer tmp
        
C
C       On ouvre le fichier test27.med en lecture seule
	call efouvr(fid,'test27.med',MED_LECTURE, cret)
	print *,cret
	print *,'Ouverture du fichier test27.med'
C	
C       Combien de maillage ?
	if (cret .eq. 0) then
	   call efnmaa(fid,nmaa,cret)
	   print *,cret
	endif
C
C       On boucle sur les maillages et on ne lit que les
C       maillages structures
	if (cret .eq. 0) then
C
	   do 10 i=1,nmaa
C
C          On repere les maillages qui nous interessent
C
	      if (cret .eq. 0) then
		 call efmaai(fid,i,maa,mdim,typmaa,desc,cret)
		 print *,'Maillage de nom : ',maa
		 print *,'- Dimension : ',mdim
		 if (typmaa .eq. MED_STRUCTURE) then
		    print *,'- Type : MED_STRUCTURE'
		 else
		    print *,'- Type : MED_NON_STRUCTURE'   
		 endif
		 print *,cret
	      endif
C
C          On repere le type de la grille
	      if (cret .eq. 0 .and. typmaa .eq. MED_STRUCTURE) then
		 call efnagl(fid,maa,type,cret)
		 print *,cret
		 if (type .eq. MED_GRILLE_CARTESIENNE) then
		    print *,'- Nature de la grille : MED_GRILLE_CARTESIENNE'
		 endif
		 if (type .eq. MED_GRILLE_STANDARD) then
		    print *,'- Nature de la grille : MED_GRILLE_STANDARD'
		 endif
	      endif
C
C          On regarde la structure et les coordonnees de la grille MED_GRILLE_STANDARD
	      if ((cret .eq. 0) .and. (type .eq. MED_GRILLE_STANDARD)
     &            .and. (typmaa .eq. MED_STRUCTURE)) then
C
		 call efnema(fid,maa,MED_COOR,MED_NOEUD,0,0,nnoe,cret)
		 print *,cret
		 print *,'- Nombre de noeuds : ',nnoe
C
		 if (cret .eq. 0) then
		    call efscol(fid,maa,mdim,strgri,cret)
		    print *,cret
		    print *,'- Structure de la grille : ',strgri
		 endif
C
		 if (cret .eq. 0) then
		    call efcool(fid,maa,mdim,coo,MED_FULL_INTERLACE,MED_ALL,tmp,
     &                          0,rep,comp2,unit2,cret)
		    print *,cret
		    print *,'- Coordonnees :'
		    do 20 j=1,nnoe*mdim
		       print *,coo(j)
 20		    continue
		 endif
C
	      endif
C
	      if ((cret .eq. 0) .and. (type .eq. MED_GRILLE_CARTESIENNE)
     &             .and. (typmaa .eq. MED_STRUCTURE)) then
C
		 do 30 axe=1,mdim
		    if (axe .eq. 1) then
		       quoi = MED_COOR_IND1
		    endif
		    if (axe .eq. 2) then
		       quoi = MED_COOR_IND2
		    endif
		    if (axe .eq. 3) then
		       quoi = MED_COOR_IND3
		    endif
C                   Lecture de la taille de l'indice selon la dimension
C                   fournie par le parametre quoi
		    if (cret.eq. 0) then
		       call efnema(fid,maa,quoi,MED_NOEUD,0,0,nind,cret)
		       print *,cret
		       print *,'- Axe ',axe
		       print *,'- Nombre d indices : ',nind
		    endif
C                   Lecture des indices des coordonnees de la grille
		    if (cret .eq. 0) then
		       call eficol(fid,maa,mdim,indice,nind,axe,comp,unit,cret)
		       print *,cret
		       print *,'- Axe ',comp
		       print *,'  unite : ',unit
		       do 40 j=1,nind
			  print *,indice(j)
 40		       continue
		    endif
 30		 continue
C
	      endif
C
 10	   continue
C
	endif
C
C       On ferme le fichier
	call efferm (fid,cret)
	print *,cret
	print *,'Fermeture du fichier'
C	
	end
	
