/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_outils.h>
#include <stdlib.h>
#include <string.h>

#ifdef MAJUSCULES
#define nedfequc NOMF(EDFEQUC)
#define nedfeque NOMF(EDFEQUE)
#define nedfequl NOMF(EDFEQUL)
#define nedfncor NOMF(EDFNCOR)
#define nedfnequ NOMF(EDFNEQU)
#define nedfequi NOMF(EDFEQUI)
#else
#define nedfequc NOMF(edfequc)
#define nedfeque NOMF(edfeque)
#define nedfequl NOMF(edfequl)
#define nedfncor NOMF(edfncor)
#define nedfnequ NOMF(edfnequ)
#define nedfequi NOMF(edfequi)
#endif

#ifdef PPRO_NT
med_int 
__stdcall EDFEQUC (med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                   char *eq, unsigned int bidon2, med_int *lon2, char *desc,                        unsigned int bidon3, med_int *lon3)
#else
med_int 
nedfequc (med_int *fid, char *maa,med_int *lon1,char *eq,med_int *lon2, 
	  char *desc, med_int *lon3)
#endif
{
  med_int ret;
  char *fn1, *fn2, *fn3;

  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED2cstring(eq,  (int) * lon2);
  fn3 = _MED1cstring(desc, (int) * lon3,MED_TAILLE_DESC);

  if (!fn1 || !fn2 || !fn3)
    return(-1); 

  ret = (med_int) MEDequivCr((med_idt) *fid,(char *)fn1,(char *)fn2,
			     (char *)fn3); 

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);
  _MEDcstringFree(fn3);

  return(ret);   
}

#ifdef PPRO_NT
med_int
__stdcall EDFEQUE (med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                   char *eq, unsigned int bidon2, med_int *lon2, med_int *corr,
                   med_int *n, med_int *typ_ent, 
                   med_int *typ_geo)
#else
med_int 
nedfeque (med_int *fid, char *maa,med_int *lon1, char *eq,med_int *lon2, 
	  med_int *corr,med_int *n, 
	  med_int *typ_ent,med_int *typ_geo)
#endif
{
  med_int ret;
  char *  fn1, *fn2;

  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED2cstring(eq, (int) * lon2);

  if (!fn1 || !fn2)
    return(-1); 

  ret = (med_int) MEDequivEcr((med_idt) *fid, (char *)fn1,(char *)fn2, 
			      (med_int *) corr, (med_int) *n, 
			      (med_entite_maillage) *typ_ent, 
			      (med_geometrie_element) *typ_geo); 

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);

  return(ret);   
}

#ifdef PPRO_NT
med_int
__stdcall EDFEQUL (med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                   char *eq, unsigned int bidon2, med_int *lon2, 
	           med_int *corr, med_int *n, med_int *typ_ent, 
                   med_int *typ_geo)
#else
med_int
nedfequl (med_int *fid, char *maa,med_int *lon1, char *eq,med_int *lon2, 
	  med_int *corr,med_int *n, 
	  med_int *typ_ent, med_int *typ_geo)
#endif
{
  med_int ret;
  char *  fn1, *fn2;

  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED2cstring(eq, (int) * lon2);

  if (!fn1 || !fn2)
    return(-1); 

  ret = (med_int) MEDequivLire((med_idt) *fid, (char *)fn1,(char *)fn2, 
			       (med_int *) corr, (med_int) *n, 
			       (med_entite_maillage) *typ_ent, 
			       (med_geometrie_element) *typ_geo); 

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);

  return(ret);   
}

#ifdef PPRO_NT
med_int
__stdcall EDFNCOR(med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                  char *eq, unsigned int bidon2, med_int *lon2, 
	          med_int *typ_ent, med_int *typ_geo)
#else
med_int
nedfncor(med_int *fid, char *maa,med_int *lon1, char *eq, med_int *lon2, 
	 med_int *typ_ent, med_int *typ_geo)
#endif
{
  med_int ret;
  char *  fn1, *fn2;

  fn1 = _MED2cstring(maa, (int) * lon1);
  fn2 = _MED2cstring(eq, (int) * lon2);

  if (!fn1 || !fn2)
    return(-1); 

  ret = (med_int) MEDnCorres((med_idt) *fid,(char *)fn1,(char *)fn2, 
			     (med_entite_maillage) *typ_ent, 
			     (med_geometrie_element) *typ_geo); 

  _MEDcstringFree(fn1);
  _MEDcstringFree(fn2);

  return(ret); 
} 


#ifdef PPRO_NT
med_int
__stdcall EDFNEQU(med_int *fid, char *maa, unsigned int bidon, med_int *lon1)
#else
med_int
nedfnequ(med_int *fid, char *maa,med_int *lon1)
#endif
{
  med_int ret;
  char *  fn1;

  fn1 = _MED2cstring(maa, (int) * lon1);

  if (!fn1)
    return(-1); 

  ret = (med_int) MEDnEquiv((med_idt) *fid,(char *)fn1); 

  _MEDcstringFree(fn1);

  return(ret); 
}



#ifdef PPRO_NT
med_int 
__stdcall EDFEQUI(med_int *fid, char *maa, unsigned int bidon1, med_int *lon1,
                  med_int *ind, char *eq, unsigned int bidon2, char *des,                          unsigned int bidon3)
#else
med_int 
nedfequi(med_int *fid, char *maa,med_int *lon1,med_int *ind, char *eq,
	 char *des)
#endif
{
  med_int ret;
  char *  fn1, * fs2;
  char fs1[MED_TAILLE_DESC+1];
  fn1 = _MED2cstring(maa, (int) * lon1);
  fs2 = malloc(sizeof(char)*MED_TAILLE_NOM); 
  if (!(fn1&&fs2))
    return(-1);

  ret = (med_int) MEDequivInfo((med_idt) *fid,(char *)fn1,(int) *ind, 
			       (char *)fs2, (char *)fs1); 

  strncpy(eq,fs2,MED_TAILLE_NOM);
  _MEDfstring(eq,MED_TAILLE_NOM);
  strncpy(des,fs1,MED_TAILLE_DESC);
  _MEDfstring(des,MED_TAILLE_DESC);

  _MEDcstringFree(fn1);
  free(fs2);

  return(ret);
}     

