/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <string.h>
#include <stdlib.h>
#include <med_outils.h>

/*
 * - Nom de la fonction : MEDnVal
 * - Description :Renvoie le nbre d'lment d'un champ
 * - Parametres :
 *     - fid      (IN)  : ID du fichier HDF courant
 *     - cha      (IN)  : le nom du champ 
 *     - type_ent (IN)  : entit concern par le champ {MED_NOEUD,MED_ARETE,MED_FACE,MED_MAILLE}
 *     - type_geo (IN)  : type gomtrique de l'entit concern {MED_POINT,MED_SEG2 ......}
 *     - numdt    (IN)  : n du pas de temps (MED_NOPDT si aucun)
 *     - numo     (IN)  : n d'ordre utilis MED_NONOR si inutile
 *     - maa      (IN)  : le nom du maillage sur lequel s'applique le champ, eventuellemnt MED_NOREF 
 *     - pflmod   (IN)  : Indique s'il faut calculer la taille mmoire pour un mode MED_COMPACT ou MED_GLOBAL . 
 * - Resultat : 0 en cas de succes, -1 sinon
 */ 

med_int 
MEDnVal(med_idt fid, char *cha, med_entite_maillage type_ent, 
	med_geometrie_element type_geo,med_int numdt, med_int numo, char * maa, med_mode_profil pflmod)
{
  med_int n=-1, ngauss=0, pfluse=0;
  med_idt datagroup3=0;
  char nomdatagroup1[2*MED_TAILLE_NOM_ENTITE+2]="";
  char nomdatagroup2[2*MED_MAX_PARA+1]="";
  char tmp1   [MED_TAILLE_NOM_ENTITE+1]="";
  char chemin [MED_TAILLE_CHA+(MED_TAILLE_NOM+1)+(2*MED_TAILLE_NOM_ENTITE+2)+(2*MED_MAX_PARA+1)+(MED_TAILLE_NOM)+1]="";
  char chemin_i [MED_TAILLE_CHA+(MED_TAILLE_NOM+1)+(2*MED_TAILLE_NOM_ENTITE+2)+(2*MED_MAX_PARA+1)+(MED_TAILLE_NOM)+1]="";  
  char pfltmp[MED_TAILLE_NOM+1]="";
  char maa_i [MED_TAILLE_NOM+1]="";
  med_size   psize=0;
  
  /*
   * On inhibe le gestionnaire d'erreur HDF 
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On cree le chemin d'accs
   */
  strcpy(chemin,MED_CHA);
  strcat(chemin,cha);
  strcat(chemin,"/");

  /* On cree le nom du datagroup de niveau 1  <type_ent>[.<type_geo>] */
  if ( _MEDnomEntite(nomdatagroup1,type_ent) < 0 )
    goto ERROR;
  if ((type_ent != MED_NOEUD))
    {
      if ( _MEDnomGeometrie(tmp1,type_geo) < 0)
	goto ERROR;
      strcat(nomdatagroup1,".");
      strcat(nomdatagroup1,tmp1);
    }
  strcat(chemin,nomdatagroup1);
  strcat(chemin,"/");

  /* Creation du nom du datagroup de niveau 2 <numdt>.<numoo> */
  sprintf(nomdatagroup2,"%*li%*li",MED_MAX_PARA,(long ) numdt,MED_MAX_PARA,(long ) numo);
  strcat(chemin,nomdatagroup2);
  strcat(chemin,"/");

  /* Creation du nom du datagroup de niveau 3 <maa> */
  if ( strcmp(maa,MED_NOREF) ) 
    strcat(chemin,maa);
  else {
    strcpy(chemin_i,chemin);
    strcat(chemin_i,MED_NOM_MAI);
    if (_MEDattrStringLire(fid,chemin_i,MED_TAILLE_NOM,maa_i) < 0)
      goto ERROR;
    strcat(chemin,maa_i);
  }

  /*
   *  Acces au champ
   */
  if ((datagroup3 = _MEDdatagroupOuvrir(fid,chemin)) < 0) 
    return 0;

  switch(pflmod) {
    
  case MED_GLOBAL :
    
    if ( _MEDattrEntierLire(datagroup3,MED_NOM_NBR,&n) < 0) {
      MESSAGE("Erreur  la lecture de l'attribut MED_NOM_NBR : ");
      ISCRUTE(n);goto ERROR;
    };    
    break;
    
  case MED_COMPACT :
 
    /* Vrifier l'existence d'un profil*/
    
    if (_MEDattrStringLire(datagroup3,MED_NOM_PFL,MED_TAILLE_NOM,pfltmp) < 0){
      MESSAGE("Erreur  la lecture de l'attribut MED_NOM_PFL : ");
      SSCRUTE(pfltmp);goto ERROR;
    };   

    /* Si un profil est trouv la taille est calcule en fonction du nbre d'lments du profil*/
    /* Sinon l'appel est quivalent au mode MED_GLOBAL ); */
    if ( pfluse = (strcmp(pfltmp,MED_NOPFLi) && strcmp(pfltmp,"")) ) {
      if ( (psize = MEDnValProfil(fid,pfltmp)) < 0 ) {
	MESSAGE("Erreur  l'appel de MEDnValProfil : ");
	SSCRUTE(pfltmp);goto ERROR;
      };
    } else {
      if ( _MEDattrEntierLire(datagroup3,MED_NOM_NBR,&n) < 0) {
	MESSAGE("Erreur  la lecture de l'attribut MED_NOM_NBR : ");
	ISCRUTE(n);goto ERROR;
      };    
       break;     
    };
    
    /* Lire le nbre des points de GAUSS*/
    if (_MEDattrEntierLire(datagroup3,MED_NOM_NGA,&ngauss) < 0) {
      MESSAGE("Erreur  la lecture de l'attribut MED_NOM_NGA : ");
      ISCRUTE(ngauss);goto ERROR;
    };   

    n= ngauss * psize;
    
    break;
    
  default :
      MESSAGE("Erreur : <pflmod> doit etre positionn soit  MED_GLOBAL soit  MED_COMPACT ");
    break;
    
  }
  
  ERROR :
    
    if (datagroup3>0) 
      if ( _MEDdatagroupFermer(datagroup3) < 0) {
	MESSAGE("Impossible de fermer le datagroup : ");
	ISCRUTE(datagroup3); n = -1; 
      } 
  
  return n;
}



