%-----------------------------------------------------------------------------%
% Copyright (C) 1998-2000 University of Melbourne.
% This file may only be copied under the terms of the GNU General
% Public License - see the file COPYING in the Mercury distribution.
%-----------------------------------------------------------------------------%
% Do not edit - this file was automatically generated by
% $ADITI_ROOT/src/rosi/create_rl_code_m.
% Created Mon Mar 13 14:33:54 2000

%-----------------------------------------------------------------------------%
:- module rl_code.

%-----------------------------------------------------------------------------%
:- interface.

:- import_module list.

:- type int32		==	int.

:- type int16           ==      int.

:- type arg_num		==	int32.

:- type field_num	==	int32.

:- type var_num		==	int32.

:- type label_num	==	int32.

:- type rule_num	==	int32.

:- type rl_bytecode	==	list(bytecode).

:- type aBlob     	==	int.	% ???

:- type aDouble   	==	float.

:- type aString		==	string.

:- pred rl_code__version(int32, int32).
:- mode rl_code__version(out, out) is det.

:- pred int32_to_bytecode(int32, list(int)).
:- mode int32_to_bytecode(in, out) is det.

:- pred int16_to_bytecode(int16, list(int)).
:- mode int16_to_bytecode(in, out) is det.

:- pred aString_to_bytecode(aString, list(int)).
:- mode aString_to_bytecode(in, out) is det.

:- pred aDouble_to_bytecode(aDouble, list(int)).
:- mode aDouble_to_bytecode(in, out) is det.

:- pred aBlob_to_bytecode(aBlob, list(int)).
:- mode aBlob_to_bytecode(in, out) is det.

:- pred aInt_to_bytecode(aInt, list(int)).
:- mode aInt_to_bytecode(in, out) is det.


:- type aInt		==	int.

:- type bytecode	--->
		rl_EXP_bool_immed(int32)
	;	rl_EXP_int_immed(int32)
	;	rl_EXP_bool_push(int32)
	;	rl_EXP_int_push(int32)
	;	rl_EXP_money_push(int32)
	;	rl_EXP_flt_push(int32)
	;	rl_EXP_str_push(int32)
	;	rl_EXP_blob_push(int32)
	;	rl_EXP_bool_push_var(int32)
	;	rl_EXP_int_push_var(int32)
	;	rl_EXP_money_push_var(int32)
	;	rl_EXP_flt_push_var(int32)
	;	rl_EXP_str_push_var(int32)
	;	rl_EXP_blob_push_var(int32)
	;	rl_EXP_term_push_var(int32)
	;	rl_EXP_bool_pop_var(int32)
	;	rl_EXP_int_pop_var(int32)
	;	rl_EXP_money_pop_var(int32)
	;	rl_EXP_flt_pop_var(int32)
	;	rl_EXP_str_pop_var(int32)
	;	rl_EXP_blob_pop_var(int32)
	;	rl_EXP_term_pop_var(int32)
	;	rl_EXP_bool_dup
	;	rl_EXP_int_dup
	;	rl_EXP_money_dup
	;	rl_EXP_flt_dup
	;	rl_EXP_str_dup
	;	rl_EXP_blob_dup
	;	rl_EXP_term_dup
	;	rl_EXP_bool_pop
	;	rl_EXP_int_pop
	;	rl_EXP_money_pop
	;	rl_EXP_flt_pop
	;	rl_EXP_str_pop
	;	rl_EXP_blob_pop
	;	rl_EXP_term_pop
	;	rl_EXP_error
	;	rl_EXP_test_functor(int32)
	;	rl_EXP_new_term_var(int32,int32)
	;	rl_EXP_new_term_output(int32,int32)
	;	rl_EXP_new_term_output1(int32,int32)
	;	rl_EXP_new_term_output2(int32,int32)
	;	rl_EXP_bool_field1(int32)
	;	rl_EXP_int_field1(int32)
	;	rl_EXP_money_field1(int32)
	;	rl_EXP_flt_field1(int32)
	;	rl_EXP_str_field1(int32)
	;	rl_EXP_blob_field1(int32)
	;	rl_EXP_term_field1(int32)
	;	rl_EXP_bool_field2(int32)
	;	rl_EXP_int_field2(int32)
	;	rl_EXP_money_field2(int32)
	;	rl_EXP_flt_field2(int32)
	;	rl_EXP_str_field2(int32)
	;	rl_EXP_blob_field2(int32)
	;	rl_EXP_term_field2(int32)
	;	rl_EXP_get_bool_arg(int32)
	;	rl_EXP_get_int_arg(int32)
	;	rl_EXP_get_money_arg(int32)
	;	rl_EXP_get_flt_arg(int32)
	;	rl_EXP_get_str_arg(int32)
	;	rl_EXP_get_blob_arg(int32)
	;	rl_EXP_get_term_arg(int32)
	;	rl_EXP_set_bool_arg(int32)
	;	rl_EXP_set_int_arg(int32)
	;	rl_EXP_set_money_arg(int32)
	;	rl_EXP_set_flt_arg(int32)
	;	rl_EXP_set_str_arg(int32)
	;	rl_EXP_set_blob_arg(int32)
	;	rl_EXP_set_term_arg(int32,int32)
	;	rl_EXP_jmp(int32)
	;	rl_EXP_beqz(int32)
	;	rl_EXP_bltz(int32)
	;	rl_EXP_bgtz(int32)
	;	rl_EXP_blez(int32)
	;	rl_EXP_bgez(int32)
	;	rl_EXP_bnez(int32)
	;	rl_EXP_bt(int32)
	;	rl_EXP_bf(int32)
	;	rl_EXP_b3way(int32,int32)
	;	rl_EXP_ret
	;	rl_EXP_return_false
	;	rl_EXP_return_true
	;	rl_EXP_return_if_eqz
	;	rl_EXP_return_if_ltz
	;	rl_EXP_return_if_gtz
	;	rl_EXP_return_if_lez
	;	rl_EXP_return_if_gez
	;	rl_EXP_return_if_nez
	;	rl_EXP_fail_if_true
	;	rl_EXP_fail_if_false
	;	rl_EXP_int_result
	;	rl_EXP_bool_result
	;	rl_EXP_output_bool(int32)
	;	rl_EXP_output1_bool(int32)
	;	rl_EXP_output2_bool(int32)
	;	rl_EXP_output_int(int32)
	;	rl_EXP_output1_int(int32)
	;	rl_EXP_output2_int(int32)
	;	rl_EXP_output_money(int32)
	;	rl_EXP_output1_money(int32)
	;	rl_EXP_output2_money(int32)
	;	rl_EXP_output_flt(int32)
	;	rl_EXP_output1_flt(int32)
	;	rl_EXP_output2_flt(int32)
	;	rl_EXP_output_str(int32)
	;	rl_EXP_output1_str(int32)
	;	rl_EXP_output2_str(int32)
	;	rl_EXP_output_blob(int32)
	;	rl_EXP_output1_blob(int32)
	;	rl_EXP_output2_blob(int32)
	;	rl_EXP_output_term(int32)
	;	rl_EXP_output1_term(int32)
	;	rl_EXP_output2_term(int32)
	;	rl_EXP_int_neg
	;	rl_EXP_int_abs
	;	rl_EXP_int_tomoney
	;	rl_EXP_int_toflt
	;	rl_EXP_int_tostr
	;	rl_EXP_money_toint
	;	rl_EXP_money_toflt
	;	rl_EXP_money_tostr
	;	rl_EXP_flt_neg
	;	rl_EXP_flt_abs
	;	rl_EXP_flt_acos
	;	rl_EXP_flt_acosh
	;	rl_EXP_flt_asin
	;	rl_EXP_flt_asinh
	;	rl_EXP_flt_atan
	;	rl_EXP_flt_atanh
	;	rl_EXP_flt_ceil
	;	rl_EXP_flt_cos
	;	rl_EXP_flt_cosh
	;	rl_EXP_flt_cot
	;	rl_EXP_flt_exp
	;	rl_EXP_flt_floor
	;	rl_EXP_flt_log
	;	rl_EXP_flt_log10
	;	rl_EXP_flt_log2
	;	rl_EXP_flt_round
	;	rl_EXP_flt_sin
	;	rl_EXP_flt_sinh
	;	rl_EXP_flt_sqrt
	;	rl_EXP_flt_tan
	;	rl_EXP_flt_tanh
	;	rl_EXP_flt_toint
	;	rl_EXP_flt_tomoney
	;	rl_EXP_flt_tostr
	;	rl_EXP_bool_and
	;	rl_EXP_bool_or
	;	rl_EXP_bool_not
	;	rl_EXP_bool_cmp
	;	rl_EXP_int_eq
	;	rl_EXP_int_lt
	;	rl_EXP_int_gt
	;	rl_EXP_int_le
	;	rl_EXP_int_ge
	;	rl_EXP_int_ne
	;	rl_EXP_int_cmp
	;	rl_EXP_int_add
	;	rl_EXP_int_sub
	;	rl_EXP_int_mult
	;	rl_EXP_int_div
	;	rl_EXP_int_mod
	;	rl_EXP_int_max
	;	rl_EXP_int_min
	;	rl_EXP_money_eq
	;	rl_EXP_money_lt
	;	rl_EXP_money_gt
	;	rl_EXP_money_le
	;	rl_EXP_money_ge
	;	rl_EXP_money_ne
	;	rl_EXP_money_cmp
	;	rl_EXP_flt_eq
	;	rl_EXP_flt_lt
	;	rl_EXP_flt_gt
	;	rl_EXP_flt_le
	;	rl_EXP_flt_ge
	;	rl_EXP_flt_ne
	;	rl_EXP_flt_cmp
	;	rl_EXP_flt_add
	;	rl_EXP_flt_sub
	;	rl_EXP_flt_mult
	;	rl_EXP_flt_div
	;	rl_EXP_flt_mod
	;	rl_EXP_flt_max
	;	rl_EXP_flt_min
	;	rl_EXP_flt_pow
	;	rl_EXP_term_eq
	;	rl_EXP_term_lt
	;	rl_EXP_term_gt
	;	rl_EXP_term_le
	;	rl_EXP_term_ge
	;	rl_EXP_term_ne
	;	rl_EXP_term_cmp
	;	rl_EXP_str_reverse
	;	rl_EXP_str_tolower
	;	rl_EXP_str_toupper
	;	rl_EXP_str_length
	;	rl_EXP_str_toint
	;	rl_EXP_str_tomoney
	;	rl_EXP_str_toflt
	;	rl_EXP_str_eq
	;	rl_EXP_str_lt
	;	rl_EXP_str_gt
	;	rl_EXP_str_le
	;	rl_EXP_str_ge
	;	rl_EXP_str_ne
	;	rl_EXP_str_cmp
	;	rl_EXP_str_match
	;	rl_EXP_str_soundex
	;	rl_EXP_str_index
	;	rl_EXP_str_rindex
	;	rl_EXP_str_substr
	;	rl_EXP_str_submatch
	;	rl_EXP_define_input1_rule(int32,int32,int32,int32)
	;	rl_EXP_define_input2_rule(int32,int32,int32,int32)
	;	rl_EXP_define_var_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output1_rule(int32,int32,int32,int32)
	;	rl_EXP_define_output2_rule(int32,int32,int32,int32)
	;	rl_EXP_copy_term_var(int32)
	;	rl_EXP_copy_term_output(int32)
	;	rl_EXP_copy_term_output1(int32)
	;	rl_EXP_copy_term_output2(int32)
	;	rl_EXP_copy_term_arg(int32)
	;	rl_EXP_put_term_var(int32)
	;	rl_EXP_put_term_output(int32)
	;	rl_EXP_put_term_output1(int32)
	;	rl_EXP_put_term_output2(int32)
	;	rl_EXP_put_term_arg(int32)
	;	rl_EXP_bool_hash
	;	rl_EXP_int_hash
	;	rl_EXP_money_hash
	;	rl_EXP_flt_hash
	;	rl_EXP_str_hash
	;	rl_EXP_blob_hash
	;	rl_EXP_term_hash
	;	rl_EXP_hash_combine
	;	rl_EXP_hash_result
	;	rl_EXP_last_bytecode
	;	rl_PROC_update(int32)
	;	rl_PROC_modify
	;	rl_PROC_project_torel
	;	rl_PROC_materialise(int32)
	;	rl_PROC_insert_tuple
	;	rl_PROC_whilenotempty(int32)
	;	rl_PROC_while
	;	rl_PROC_while_end
	;	rl_PROC_setrel(int32,int32)
	;	rl_PROC_unsetrel(int32)
	;	rl_PROC_declrel(int32,int32)
	;	rl_PROC_grouprels
	;	rl_PROC_getschemaspec
	;	rl_PROC_setschema(int32)
	;	rl_PROC_settemprel(int32,int32,int32)
	;	rl_PROC_createtemprel(int32,int32)
	;	rl_PROC_nametemprel(int32,int32)
	;	rl_PROC_openpermrel(int32,int32,int32)
	;	rl_PROC_createpermrel(int32,int32,int32)
	;	rl_PROC_addindextorel(int32,int32)
	;	rl_PROC_addindextoschema(int32)
	;	rl_PROC_clear(int32)
	;	rl_PROC_drop(int32)
	;	rl_PROC_dropindex(int32)
	;	rl_PROC_begintransaction(int32,int32)
	;	rl_PROC_savepoint(int32)
	;	rl_PROC_rollback(int32)
	;	rl_PROC_commit
	;	rl_PROC_abort
	;	rl_PROC_delete(int32)
	;	rl_PROC_insert(int32)
	;	rl_PROC_bind_code(int32)
	;	rl_PROC_bind_handle(int32)
	;	rl_PROC_call(int32)
	;	rl_PROC_label(int32)
	;	rl_PROC_goto(int32)
	;	rl_PROC_conditional_goto(int32)
	;	rl_PROC_goto_label(int32)
	;	rl_PROC_conditional_goto_label(int32)
	;	rl_PROC_notempty
	;	rl_PROC_empty
	;	rl_PROC_one_reference(int32)
	;	rl_PROC_is_permanent(int32)
	;	rl_PROC_has_index(int32,int32)
	;	rl_PROC_and
	;	rl_PROC_or
	;	rl_PROC_not
	;	rl_PROC_stream
	;	rl_PROC_stream_end
	;	rl_PROC_stream_list_cons
	;	rl_PROC_stream_list_nil
	;	rl_PROC_var(int32,int32)
	;	rl_PROC_indexed_var(int32,int32,int32)
	;	rl_PROC_var_list_cons(int32,int32)
	;	rl_PROC_var_list_nil
	;	rl_PROC_expr(int32)
	;	rl_PROC_expr_frag(int32)
	;	rl_PROC_expr_end
	;	rl_PROC_expr_list_cons(int32)
	;	rl_PROC_expr_list_nil
	;	rl_PROC_bool_op_list_cons
	;	rl_PROC_bool_op_list_nil
	;	rl_PROC_int_list_cons(int32)
	;	rl_PROC_int_list_nil
	;	rl_PROC_ret
	;	rl_PROC_join
	;	rl_PROC_join_nl
	;	rl_PROC_join_sm
	;	rl_PROC_join_hj
	;	rl_PROC_join_index_simple(int32)
	;	rl_PROC_join_index_complex
	;	rl_PROC_join_cross
	;	rl_PROC_semijoin_nl
	;	rl_PROC_semijoin_sm
	;	rl_PROC_semijoin_hj
	;	rl_PROC_semijoin_index(int32,int32)
	;	rl_PROC_subtract
	;	rl_PROC_subtract_nl
	;	rl_PROC_subtract_sm
	;	rl_PROC_subtract_hj
	;	rl_PROC_subtract_index(int32)
	;	rl_PROC_subtract_cross
	;	rl_PROC_semisubtract_nl
	;	rl_PROC_semisubtract_hj
	;	rl_PROC_semisubtract_index(int32)
	;	rl_PROC_difference
	;	rl_PROC_select
	;	rl_PROC_select_filter
	;	rl_PROC_select_index(int32)
	;	rl_PROC_btree_scan(int32)
	;	rl_PROC_project_tee
	;	rl_PROC_sort(int32)
	;	rl_PROC_union
	;	rl_PROC_union_sm
	;	rl_PROC_uniondiff
	;	rl_PROC_uniondiff_sm
	;	rl_PROC_uniondiff_btree
	;	rl_PROC_aggregate
	;	rl_PROC_aggregate_sm
	;	rl_PROC_aggregate_onegroup
	;	rl_PROC_insert_tuple_stream
	;	rl_PROC_empty_stream(int32)
	;	rl_PROC_hypothetical
	;	rl_PROC_topdown
	;	rl_PROC_last_bytecode
	;	rl_HEAD_proc(int32,int32,int32,int32)
	;	rl_HEAD_proc_end
	;	rl_HEAD_const_int(int32,aInt)
	;	rl_HEAD_const_flt(int32,aDouble)
	;	rl_HEAD_const_str(int32,aString)
	;	rl_HEAD_var_int(int32)
	;	rl_HEAD_var_flt(int32)
	;	rl_HEAD_var_str(int32)
	;	rl_HEAD_var_term(int32)
	;	rl_HEAD_var_stream(int32)
	;	rl_HEAD_define_rule(int32,int32,int32)
	;	rl_HEAD_last_bytecode
	.


:- pred bytecode_to_intlist(bytecode, list(int)).
:- mode bytecode_to_intlist(in, out) is det.

%:- pred bytecode_to_str(bytecode, string).
%:- mode bytecode_to_str(in, out) is det.
%
%:- pred bytecode_name_to_int(bytecode, int).
%:- mode bytecode_name_to_int(in, out) is det.
%
%:- pred bytecode_name_to_str(bytecode, string).
%:- mode bytecode_name_to_str(in, out) is det.

%-----------------------------------------------------------------------------%
:- implementation.

:- import_module bytecode_data.

%-----------------------------------------------------------------------------%

bytecode_to_intlist(rl_EXP_bool_immed(X0int32),	 Splits) :-
	int16_to_bytecode(0, I0Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I0Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_EXP_int_immed(X0int32),	 Splits) :-
	int16_to_bytecode(1, I1Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I1Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_push(X0aInt),	 Splits) :-
	int16_to_bytecode(2, I2Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list__condense([I2Codes,X0aIntCodes], Splits).
bytecode_to_intlist(rl_EXP_int_push(X0aInt),	 Splits) :-
	int16_to_bytecode(3, I3Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list__condense([I3Codes,X0aIntCodes], Splits).
bytecode_to_intlist(rl_EXP_money_push(X0aInt),	 Splits) :-
	int16_to_bytecode(4, I4Codes),
	int32_to_bytecode(X0aInt, X0aIntCodes),
	list__condense([I4Codes,X0aIntCodes], Splits).
bytecode_to_intlist(rl_EXP_flt_push(X0aDouble),	 Splits) :-
	int16_to_bytecode(5, I5Codes),
	int32_to_bytecode(X0aDouble, X0aDoubleCodes),
	list__condense([I5Codes,X0aDoubleCodes], Splits).
bytecode_to_intlist(rl_EXP_str_push(X0aString),	 Splits) :-
	int16_to_bytecode(6, I6Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list__condense([I6Codes,X0aStringCodes], Splits).
bytecode_to_intlist(rl_EXP_blob_push(X0aBlob),	 Splits) :-
	int16_to_bytecode(7, I7Codes),
	int32_to_bytecode(X0aBlob, X0aBlobCodes),
	list__condense([I7Codes,X0aBlobCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(8, I8Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I8Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_int_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(9, I9Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I9Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_money_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(10, I10Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I10Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_flt_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(11, I11Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I11Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_str_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(12, I12Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I12Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_blob_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(13, I13Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I13Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_term_push_var(X0var_num),	 Splits) :-
	int16_to_bytecode(14, I14Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I14Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(15, I15Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I15Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_int_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(16, I16Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I16Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_money_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(17, I17Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I17Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_flt_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(18, I18Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I18Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_str_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(19, I19Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I19Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_blob_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(20, I20Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I20Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_term_pop_var(X0var_num),	 Splits) :-
	int16_to_bytecode(21, I21Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I21Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_dup,	 Splits) :-
	int16_to_bytecode(22, I22Codes),
	list__condense([I22Codes], Splits).
bytecode_to_intlist(rl_EXP_int_dup,	 Splits) :-
	int16_to_bytecode(23, I23Codes),
	list__condense([I23Codes], Splits).
bytecode_to_intlist(rl_EXP_money_dup,	 Splits) :-
	int16_to_bytecode(24, I24Codes),
	list__condense([I24Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_dup,	 Splits) :-
	int16_to_bytecode(25, I25Codes),
	list__condense([I25Codes], Splits).
bytecode_to_intlist(rl_EXP_str_dup,	 Splits) :-
	int16_to_bytecode(26, I26Codes),
	list__condense([I26Codes], Splits).
bytecode_to_intlist(rl_EXP_blob_dup,	 Splits) :-
	int16_to_bytecode(27, I27Codes),
	list__condense([I27Codes], Splits).
bytecode_to_intlist(rl_EXP_term_dup,	 Splits) :-
	int16_to_bytecode(28, I28Codes),
	list__condense([I28Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_pop,	 Splits) :-
	int16_to_bytecode(29, I29Codes),
	list__condense([I29Codes], Splits).
bytecode_to_intlist(rl_EXP_int_pop,	 Splits) :-
	int16_to_bytecode(30, I30Codes),
	list__condense([I30Codes], Splits).
bytecode_to_intlist(rl_EXP_money_pop,	 Splits) :-
	int16_to_bytecode(31, I31Codes),
	list__condense([I31Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_pop,	 Splits) :-
	int16_to_bytecode(32, I32Codes),
	list__condense([I32Codes], Splits).
bytecode_to_intlist(rl_EXP_str_pop,	 Splits) :-
	int16_to_bytecode(33, I33Codes),
	list__condense([I33Codes], Splits).
bytecode_to_intlist(rl_EXP_blob_pop,	 Splits) :-
	int16_to_bytecode(34, I34Codes),
	list__condense([I34Codes], Splits).
bytecode_to_intlist(rl_EXP_term_pop,	 Splits) :-
	int16_to_bytecode(35, I35Codes),
	list__condense([I35Codes], Splits).
bytecode_to_intlist(rl_EXP_error,	 Splits) :-
	int16_to_bytecode(36, I36Codes),
	list__condense([I36Codes], Splits).
bytecode_to_intlist(rl_EXP_test_functor(X0rule_num),	 Splits) :-
	int16_to_bytecode(37, I37Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	list__condense([I37Codes,X0rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_new_term_var(X0var_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(38, I38Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	list__condense([I38Codes,X0var_numCodes,X1rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_new_term_output(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(39, I39Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	list__condense([I39Codes,X0field_numCodes,X1rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_new_term_output1(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(40, I40Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	list__condense([I40Codes,X0field_numCodes,X1rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_new_term_output2(X0field_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(41, I41Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	list__condense([I41Codes,X0field_numCodes,X1rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(42, I42Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I42Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_int_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(43, I43Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I43Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_money_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(44, I44Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I44Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_flt_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(45, I45Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I45Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_str_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(46, I46Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I46Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_blob_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(47, I47Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I47Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_term_field1(X0field_num),	 Splits) :-
	int16_to_bytecode(48, I48Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I48Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(49, I49Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I49Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_int_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(50, I50Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I50Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_money_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(51, I51Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I51Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_flt_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(52, I52Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I52Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_str_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(53, I53Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I53Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_blob_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(54, I54Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I54Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_term_field2(X0field_num),	 Splits) :-
	int16_to_bytecode(55, I55Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I55Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_bool_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(56, I56Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I56Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_int_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(57, I57Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I57Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_money_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(58, I58Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I58Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_flt_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(59, I59Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I59Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_str_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(60, I60Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I60Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_blob_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(61, I61Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I61Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_get_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(62, I62Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I62Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_bool_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(63, I63Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I63Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_int_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(64, I64Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I64Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_money_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(65, I65Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I65Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_flt_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(66, I66Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I66Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_str_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(67, I67Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I67Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_blob_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(68, I68Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I68Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_set_term_arg(X0arg_num,X1rule_num),	 Splits) :-
	int16_to_bytecode(69, I69Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	int32_to_bytecode(X1rule_num, X1rule_numCodes),
	list__condense([I69Codes,X0arg_numCodes,X1rule_numCodes], Splits).
bytecode_to_intlist(rl_EXP_jmp(X0label_num),	 Splits) :-
	int16_to_bytecode(70, I70Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I70Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_beqz(X0label_num),	 Splits) :-
	int16_to_bytecode(71, I71Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I71Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bltz(X0label_num),	 Splits) :-
	int16_to_bytecode(72, I72Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I72Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bgtz(X0label_num),	 Splits) :-
	int16_to_bytecode(73, I73Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I73Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_blez(X0label_num),	 Splits) :-
	int16_to_bytecode(74, I74Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I74Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bgez(X0label_num),	 Splits) :-
	int16_to_bytecode(75, I75Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I75Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bnez(X0label_num),	 Splits) :-
	int16_to_bytecode(76, I76Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I76Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bt(X0label_num),	 Splits) :-
	int16_to_bytecode(77, I77Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I77Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bf(X0label_num),	 Splits) :-
	int16_to_bytecode(78, I78Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	list__condense([I78Codes,X0label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_b3way(X0label_num,X1label_num),	 Splits) :-
	int16_to_bytecode(79, I79Codes),
	int32_to_bytecode(X0label_num, X0label_numCodes),
	int32_to_bytecode(X1label_num, X1label_numCodes),
	list__condense([I79Codes,X0label_numCodes,X1label_numCodes], Splits).
bytecode_to_intlist(rl_EXP_ret,	 Splits) :-
	int16_to_bytecode(80, I80Codes),
	list__condense([I80Codes], Splits).
bytecode_to_intlist(rl_EXP_return_false,	 Splits) :-
	int16_to_bytecode(81, I81Codes),
	list__condense([I81Codes], Splits).
bytecode_to_intlist(rl_EXP_return_true,	 Splits) :-
	int16_to_bytecode(82, I82Codes),
	list__condense([I82Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_eqz,	 Splits) :-
	int16_to_bytecode(83, I83Codes),
	list__condense([I83Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_ltz,	 Splits) :-
	int16_to_bytecode(84, I84Codes),
	list__condense([I84Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_gtz,	 Splits) :-
	int16_to_bytecode(85, I85Codes),
	list__condense([I85Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_lez,	 Splits) :-
	int16_to_bytecode(86, I86Codes),
	list__condense([I86Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_gez,	 Splits) :-
	int16_to_bytecode(87, I87Codes),
	list__condense([I87Codes], Splits).
bytecode_to_intlist(rl_EXP_return_if_nez,	 Splits) :-
	int16_to_bytecode(88, I88Codes),
	list__condense([I88Codes], Splits).
bytecode_to_intlist(rl_EXP_fail_if_true,	 Splits) :-
	int16_to_bytecode(89, I89Codes),
	list__condense([I89Codes], Splits).
bytecode_to_intlist(rl_EXP_fail_if_false,	 Splits) :-
	int16_to_bytecode(90, I90Codes),
	list__condense([I90Codes], Splits).
bytecode_to_intlist(rl_EXP_int_result,	 Splits) :-
	int16_to_bytecode(91, I91Codes),
	list__condense([I91Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_result,	 Splits) :-
	int16_to_bytecode(92, I92Codes),
	list__condense([I92Codes], Splits).
bytecode_to_intlist(rl_EXP_output_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(93, I93Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I93Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(94, I94Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I94Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_bool(X0field_num),	 Splits) :-
	int16_to_bytecode(95, I95Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I95Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_int(X0field_num),	 Splits) :-
	int16_to_bytecode(96, I96Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I96Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_int(X0field_num),	 Splits) :-
	int16_to_bytecode(97, I97Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I97Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_int(X0field_num),	 Splits) :-
	int16_to_bytecode(98, I98Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I98Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_money(X0field_num),	 Splits) :-
	int16_to_bytecode(99, I99Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I99Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_money(X0field_num),	 Splits) :-
	int16_to_bytecode(100, I100Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I100Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_money(X0field_num),	 Splits) :-
	int16_to_bytecode(101, I101Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I101Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(102, I102Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I102Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(103, I103Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I103Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_flt(X0field_num),	 Splits) :-
	int16_to_bytecode(104, I104Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I104Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_str(X0field_num),	 Splits) :-
	int16_to_bytecode(105, I105Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I105Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_str(X0field_num),	 Splits) :-
	int16_to_bytecode(106, I106Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I106Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_str(X0field_num),	 Splits) :-
	int16_to_bytecode(107, I107Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I107Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(108, I108Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I108Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(109, I109Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I109Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_blob(X0field_num),	 Splits) :-
	int16_to_bytecode(110, I110Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I110Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output_term(X0field_num),	 Splits) :-
	int16_to_bytecode(111, I111Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I111Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output1_term(X0field_num),	 Splits) :-
	int16_to_bytecode(112, I112Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I112Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_output2_term(X0field_num),	 Splits) :-
	int16_to_bytecode(113, I113Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I113Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_int_neg,	 Splits) :-
	int16_to_bytecode(114, I114Codes),
	list__condense([I114Codes], Splits).
bytecode_to_intlist(rl_EXP_int_abs,	 Splits) :-
	int16_to_bytecode(115, I115Codes),
	list__condense([I115Codes], Splits).
bytecode_to_intlist(rl_EXP_int_tomoney,	 Splits) :-
	int16_to_bytecode(116, I116Codes),
	list__condense([I116Codes], Splits).
bytecode_to_intlist(rl_EXP_int_toflt,	 Splits) :-
	int16_to_bytecode(117, I117Codes),
	list__condense([I117Codes], Splits).
bytecode_to_intlist(rl_EXP_int_tostr,	 Splits) :-
	int16_to_bytecode(118, I118Codes),
	list__condense([I118Codes], Splits).
bytecode_to_intlist(rl_EXP_money_toint,	 Splits) :-
	int16_to_bytecode(119, I119Codes),
	list__condense([I119Codes], Splits).
bytecode_to_intlist(rl_EXP_money_toflt,	 Splits) :-
	int16_to_bytecode(120, I120Codes),
	list__condense([I120Codes], Splits).
bytecode_to_intlist(rl_EXP_money_tostr,	 Splits) :-
	int16_to_bytecode(121, I121Codes),
	list__condense([I121Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_neg,	 Splits) :-
	int16_to_bytecode(122, I122Codes),
	list__condense([I122Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_abs,	 Splits) :-
	int16_to_bytecode(123, I123Codes),
	list__condense([I123Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_acos,	 Splits) :-
	int16_to_bytecode(124, I124Codes),
	list__condense([I124Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_acosh,	 Splits) :-
	int16_to_bytecode(125, I125Codes),
	list__condense([I125Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_asin,	 Splits) :-
	int16_to_bytecode(126, I126Codes),
	list__condense([I126Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_asinh,	 Splits) :-
	int16_to_bytecode(127, I127Codes),
	list__condense([I127Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_atan,	 Splits) :-
	int16_to_bytecode(128, I128Codes),
	list__condense([I128Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_atanh,	 Splits) :-
	int16_to_bytecode(129, I129Codes),
	list__condense([I129Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_ceil,	 Splits) :-
	int16_to_bytecode(130, I130Codes),
	list__condense([I130Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_cos,	 Splits) :-
	int16_to_bytecode(131, I131Codes),
	list__condense([I131Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_cosh,	 Splits) :-
	int16_to_bytecode(132, I132Codes),
	list__condense([I132Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_cot,	 Splits) :-
	int16_to_bytecode(133, I133Codes),
	list__condense([I133Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_exp,	 Splits) :-
	int16_to_bytecode(134, I134Codes),
	list__condense([I134Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_floor,	 Splits) :-
	int16_to_bytecode(135, I135Codes),
	list__condense([I135Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_log,	 Splits) :-
	int16_to_bytecode(136, I136Codes),
	list__condense([I136Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_log10,	 Splits) :-
	int16_to_bytecode(137, I137Codes),
	list__condense([I137Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_log2,	 Splits) :-
	int16_to_bytecode(138, I138Codes),
	list__condense([I138Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_round,	 Splits) :-
	int16_to_bytecode(139, I139Codes),
	list__condense([I139Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_sin,	 Splits) :-
	int16_to_bytecode(140, I140Codes),
	list__condense([I140Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_sinh,	 Splits) :-
	int16_to_bytecode(141, I141Codes),
	list__condense([I141Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_sqrt,	 Splits) :-
	int16_to_bytecode(142, I142Codes),
	list__condense([I142Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_tan,	 Splits) :-
	int16_to_bytecode(143, I143Codes),
	list__condense([I143Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_tanh,	 Splits) :-
	int16_to_bytecode(144, I144Codes),
	list__condense([I144Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_toint,	 Splits) :-
	int16_to_bytecode(145, I145Codes),
	list__condense([I145Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_tomoney,	 Splits) :-
	int16_to_bytecode(146, I146Codes),
	list__condense([I146Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_tostr,	 Splits) :-
	int16_to_bytecode(147, I147Codes),
	list__condense([I147Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_and,	 Splits) :-
	int16_to_bytecode(148, I148Codes),
	list__condense([I148Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_or,	 Splits) :-
	int16_to_bytecode(149, I149Codes),
	list__condense([I149Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_not,	 Splits) :-
	int16_to_bytecode(150, I150Codes),
	list__condense([I150Codes], Splits).
bytecode_to_intlist(rl_EXP_bool_cmp,	 Splits) :-
	int16_to_bytecode(151, I151Codes),
	list__condense([I151Codes], Splits).
bytecode_to_intlist(rl_EXP_int_eq,	 Splits) :-
	int16_to_bytecode(152, I152Codes),
	list__condense([I152Codes], Splits).
bytecode_to_intlist(rl_EXP_int_lt,	 Splits) :-
	int16_to_bytecode(153, I153Codes),
	list__condense([I153Codes], Splits).
bytecode_to_intlist(rl_EXP_int_gt,	 Splits) :-
	int16_to_bytecode(154, I154Codes),
	list__condense([I154Codes], Splits).
bytecode_to_intlist(rl_EXP_int_le,	 Splits) :-
	int16_to_bytecode(155, I155Codes),
	list__condense([I155Codes], Splits).
bytecode_to_intlist(rl_EXP_int_ge,	 Splits) :-
	int16_to_bytecode(156, I156Codes),
	list__condense([I156Codes], Splits).
bytecode_to_intlist(rl_EXP_int_ne,	 Splits) :-
	int16_to_bytecode(157, I157Codes),
	list__condense([I157Codes], Splits).
bytecode_to_intlist(rl_EXP_int_cmp,	 Splits) :-
	int16_to_bytecode(158, I158Codes),
	list__condense([I158Codes], Splits).
bytecode_to_intlist(rl_EXP_int_add,	 Splits) :-
	int16_to_bytecode(159, I159Codes),
	list__condense([I159Codes], Splits).
bytecode_to_intlist(rl_EXP_int_sub,	 Splits) :-
	int16_to_bytecode(160, I160Codes),
	list__condense([I160Codes], Splits).
bytecode_to_intlist(rl_EXP_int_mult,	 Splits) :-
	int16_to_bytecode(161, I161Codes),
	list__condense([I161Codes], Splits).
bytecode_to_intlist(rl_EXP_int_div,	 Splits) :-
	int16_to_bytecode(162, I162Codes),
	list__condense([I162Codes], Splits).
bytecode_to_intlist(rl_EXP_int_mod,	 Splits) :-
	int16_to_bytecode(163, I163Codes),
	list__condense([I163Codes], Splits).
bytecode_to_intlist(rl_EXP_int_max,	 Splits) :-
	int16_to_bytecode(164, I164Codes),
	list__condense([I164Codes], Splits).
bytecode_to_intlist(rl_EXP_int_min,	 Splits) :-
	int16_to_bytecode(165, I165Codes),
	list__condense([I165Codes], Splits).
bytecode_to_intlist(rl_EXP_money_eq,	 Splits) :-
	int16_to_bytecode(166, I166Codes),
	list__condense([I166Codes], Splits).
bytecode_to_intlist(rl_EXP_money_lt,	 Splits) :-
	int16_to_bytecode(167, I167Codes),
	list__condense([I167Codes], Splits).
bytecode_to_intlist(rl_EXP_money_gt,	 Splits) :-
	int16_to_bytecode(168, I168Codes),
	list__condense([I168Codes], Splits).
bytecode_to_intlist(rl_EXP_money_le,	 Splits) :-
	int16_to_bytecode(169, I169Codes),
	list__condense([I169Codes], Splits).
bytecode_to_intlist(rl_EXP_money_ge,	 Splits) :-
	int16_to_bytecode(170, I170Codes),
	list__condense([I170Codes], Splits).
bytecode_to_intlist(rl_EXP_money_ne,	 Splits) :-
	int16_to_bytecode(171, I171Codes),
	list__condense([I171Codes], Splits).
bytecode_to_intlist(rl_EXP_money_cmp,	 Splits) :-
	int16_to_bytecode(172, I172Codes),
	list__condense([I172Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_eq,	 Splits) :-
	int16_to_bytecode(173, I173Codes),
	list__condense([I173Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_lt,	 Splits) :-
	int16_to_bytecode(174, I174Codes),
	list__condense([I174Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_gt,	 Splits) :-
	int16_to_bytecode(175, I175Codes),
	list__condense([I175Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_le,	 Splits) :-
	int16_to_bytecode(176, I176Codes),
	list__condense([I176Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_ge,	 Splits) :-
	int16_to_bytecode(177, I177Codes),
	list__condense([I177Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_ne,	 Splits) :-
	int16_to_bytecode(178, I178Codes),
	list__condense([I178Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_cmp,	 Splits) :-
	int16_to_bytecode(179, I179Codes),
	list__condense([I179Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_add,	 Splits) :-
	int16_to_bytecode(180, I180Codes),
	list__condense([I180Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_sub,	 Splits) :-
	int16_to_bytecode(181, I181Codes),
	list__condense([I181Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_mult,	 Splits) :-
	int16_to_bytecode(182, I182Codes),
	list__condense([I182Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_div,	 Splits) :-
	int16_to_bytecode(183, I183Codes),
	list__condense([I183Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_mod,	 Splits) :-
	int16_to_bytecode(184, I184Codes),
	list__condense([I184Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_max,	 Splits) :-
	int16_to_bytecode(185, I185Codes),
	list__condense([I185Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_min,	 Splits) :-
	int16_to_bytecode(186, I186Codes),
	list__condense([I186Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_pow,	 Splits) :-
	int16_to_bytecode(187, I187Codes),
	list__condense([I187Codes], Splits).
bytecode_to_intlist(rl_EXP_term_eq,	 Splits) :-
	int16_to_bytecode(188, I188Codes),
	list__condense([I188Codes], Splits).
bytecode_to_intlist(rl_EXP_term_lt,	 Splits) :-
	int16_to_bytecode(189, I189Codes),
	list__condense([I189Codes], Splits).
bytecode_to_intlist(rl_EXP_term_gt,	 Splits) :-
	int16_to_bytecode(190, I190Codes),
	list__condense([I190Codes], Splits).
bytecode_to_intlist(rl_EXP_term_le,	 Splits) :-
	int16_to_bytecode(191, I191Codes),
	list__condense([I191Codes], Splits).
bytecode_to_intlist(rl_EXP_term_ge,	 Splits) :-
	int16_to_bytecode(192, I192Codes),
	list__condense([I192Codes], Splits).
bytecode_to_intlist(rl_EXP_term_ne,	 Splits) :-
	int16_to_bytecode(193, I193Codes),
	list__condense([I193Codes], Splits).
bytecode_to_intlist(rl_EXP_term_cmp,	 Splits) :-
	int16_to_bytecode(194, I194Codes),
	list__condense([I194Codes], Splits).
bytecode_to_intlist(rl_EXP_str_reverse,	 Splits) :-
	int16_to_bytecode(195, I195Codes),
	list__condense([I195Codes], Splits).
bytecode_to_intlist(rl_EXP_str_tolower,	 Splits) :-
	int16_to_bytecode(196, I196Codes),
	list__condense([I196Codes], Splits).
bytecode_to_intlist(rl_EXP_str_toupper,	 Splits) :-
	int16_to_bytecode(197, I197Codes),
	list__condense([I197Codes], Splits).
bytecode_to_intlist(rl_EXP_str_length,	 Splits) :-
	int16_to_bytecode(198, I198Codes),
	list__condense([I198Codes], Splits).
bytecode_to_intlist(rl_EXP_str_toint,	 Splits) :-
	int16_to_bytecode(199, I199Codes),
	list__condense([I199Codes], Splits).
bytecode_to_intlist(rl_EXP_str_tomoney,	 Splits) :-
	int16_to_bytecode(200, I200Codes),
	list__condense([I200Codes], Splits).
bytecode_to_intlist(rl_EXP_str_toflt,	 Splits) :-
	int16_to_bytecode(201, I201Codes),
	list__condense([I201Codes], Splits).
bytecode_to_intlist(rl_EXP_str_eq,	 Splits) :-
	int16_to_bytecode(202, I202Codes),
	list__condense([I202Codes], Splits).
bytecode_to_intlist(rl_EXP_str_lt,	 Splits) :-
	int16_to_bytecode(203, I203Codes),
	list__condense([I203Codes], Splits).
bytecode_to_intlist(rl_EXP_str_gt,	 Splits) :-
	int16_to_bytecode(204, I204Codes),
	list__condense([I204Codes], Splits).
bytecode_to_intlist(rl_EXP_str_le,	 Splits) :-
	int16_to_bytecode(205, I205Codes),
	list__condense([I205Codes], Splits).
bytecode_to_intlist(rl_EXP_str_ge,	 Splits) :-
	int16_to_bytecode(206, I206Codes),
	list__condense([I206Codes], Splits).
bytecode_to_intlist(rl_EXP_str_ne,	 Splits) :-
	int16_to_bytecode(207, I207Codes),
	list__condense([I207Codes], Splits).
bytecode_to_intlist(rl_EXP_str_cmp,	 Splits) :-
	int16_to_bytecode(208, I208Codes),
	list__condense([I208Codes], Splits).
bytecode_to_intlist(rl_EXP_str_match,	 Splits) :-
	int16_to_bytecode(209, I209Codes),
	list__condense([I209Codes], Splits).
bytecode_to_intlist(rl_EXP_str_soundex,	 Splits) :-
	int16_to_bytecode(210, I210Codes),
	list__condense([I210Codes], Splits).
bytecode_to_intlist(rl_EXP_str_index,	 Splits) :-
	int16_to_bytecode(211, I211Codes),
	list__condense([I211Codes], Splits).
bytecode_to_intlist(rl_EXP_str_rindex,	 Splits) :-
	int16_to_bytecode(212, I212Codes),
	list__condense([I212Codes], Splits).
bytecode_to_intlist(rl_EXP_str_substr,	 Splits) :-
	int16_to_bytecode(213, I213Codes),
	list__condense([I213Codes], Splits).
bytecode_to_intlist(rl_EXP_str_submatch,	 Splits) :-
	int16_to_bytecode(214, I214Codes),
	list__condense([I214Codes], Splits).
bytecode_to_intlist(rl_EXP_define_input1_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(215, I215Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I215Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_define_input2_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(216, I216Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I216Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_define_var_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(217, I217Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I217Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_define_output_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(218, I218Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I218Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_define_output1_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(219, I219Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I219Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_define_output2_rule(X0rule_num,X1aString,X2aString,X3arg_num),	 Splits) :-
	int16_to_bytecode(220, I220Codes),
	int32_to_bytecode(X0rule_num, X0rule_numCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3arg_num, X3arg_numCodes),
	list__condense([I220Codes,X0rule_numCodes,X1aStringCodes,X2aStringCodes,X3arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_copy_term_var(X0var_num),	 Splits) :-
	int16_to_bytecode(221, I221Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I221Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_copy_term_output(X0field_num),	 Splits) :-
	int16_to_bytecode(222, I222Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I222Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_copy_term_output1(X0field_num),	 Splits) :-
	int16_to_bytecode(223, I223Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I223Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_copy_term_output2(X0field_num),	 Splits) :-
	int16_to_bytecode(224, I224Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I224Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_copy_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(225, I225Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I225Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_put_term_var(X0var_num),	 Splits) :-
	int16_to_bytecode(226, I226Codes),
	int32_to_bytecode(X0var_num, X0var_numCodes),
	list__condense([I226Codes,X0var_numCodes], Splits).
bytecode_to_intlist(rl_EXP_put_term_output(X0field_num),	 Splits) :-
	int16_to_bytecode(227, I227Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I227Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_put_term_output1(X0field_num),	 Splits) :-
	int16_to_bytecode(228, I228Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I228Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_put_term_output2(X0field_num),	 Splits) :-
	int16_to_bytecode(229, I229Codes),
	int32_to_bytecode(X0field_num, X0field_numCodes),
	list__condense([I229Codes,X0field_numCodes], Splits).
bytecode_to_intlist(rl_EXP_put_term_arg(X0arg_num),	 Splits) :-
	int16_to_bytecode(230, I230Codes),
	int32_to_bytecode(X0arg_num, X0arg_numCodes),
	list__condense([I230Codes,X0arg_numCodes], Splits).
bytecode_to_intlist(rl_EXP_bool_hash,	 Splits) :-
	int16_to_bytecode(231, I231Codes),
	list__condense([I231Codes], Splits).
bytecode_to_intlist(rl_EXP_int_hash,	 Splits) :-
	int16_to_bytecode(232, I232Codes),
	list__condense([I232Codes], Splits).
bytecode_to_intlist(rl_EXP_money_hash,	 Splits) :-
	int16_to_bytecode(233, I233Codes),
	list__condense([I233Codes], Splits).
bytecode_to_intlist(rl_EXP_flt_hash,	 Splits) :-
	int16_to_bytecode(234, I234Codes),
	list__condense([I234Codes], Splits).
bytecode_to_intlist(rl_EXP_str_hash,	 Splits) :-
	int16_to_bytecode(235, I235Codes),
	list__condense([I235Codes], Splits).
bytecode_to_intlist(rl_EXP_blob_hash,	 Splits) :-
	int16_to_bytecode(236, I236Codes),
	list__condense([I236Codes], Splits).
bytecode_to_intlist(rl_EXP_term_hash,	 Splits) :-
	int16_to_bytecode(237, I237Codes),
	list__condense([I237Codes], Splits).
bytecode_to_intlist(rl_EXP_hash_combine,	 Splits) :-
	int16_to_bytecode(238, I238Codes),
	list__condense([I238Codes], Splits).
bytecode_to_intlist(rl_EXP_hash_result,	 Splits) :-
	int16_to_bytecode(239, I239Codes),
	list__condense([I239Codes], Splits).
bytecode_to_intlist(rl_EXP_last_bytecode,	 Splits) :-
	int16_to_bytecode(240, I240Codes),
	list__condense([I240Codes], Splits).
bytecode_to_intlist(rl_PROC_update(X0int32),	 Splits) :-
	int16_to_bytecode(241, I241Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I241Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_modify,	 Splits) :-
	int16_to_bytecode(242, I242Codes),
	list__condense([I242Codes], Splits).
bytecode_to_intlist(rl_PROC_project_torel,	 Splits) :-
	int16_to_bytecode(243, I243Codes),
	list__condense([I243Codes], Splits).
bytecode_to_intlist(rl_PROC_materialise(X0int32),	 Splits) :-
	int16_to_bytecode(244, I244Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I244Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_insert_tuple,	 Splits) :-
	int16_to_bytecode(245, I245Codes),
	list__condense([I245Codes], Splits).
bytecode_to_intlist(rl_PROC_whilenotempty(X0int32),	 Splits) :-
	int16_to_bytecode(246, I246Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I246Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_while,	 Splits) :-
	int16_to_bytecode(247, I247Codes),
	list__condense([I247Codes], Splits).
bytecode_to_intlist(rl_PROC_while_end,	 Splits) :-
	int16_to_bytecode(248, I248Codes),
	list__condense([I248Codes], Splits).
bytecode_to_intlist(rl_PROC_setrel(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(249, I249Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I249Codes,X0int32Codes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_unsetrel(X0int32),	 Splits) :-
	int16_to_bytecode(250, I250Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I250Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_declrel(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(251, I251Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I251Codes,X0int32Codes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_grouprels,	 Splits) :-
	int16_to_bytecode(252, I252Codes),
	list__condense([I252Codes], Splits).
bytecode_to_intlist(rl_PROC_getschemaspec,	 Splits) :-
	int16_to_bytecode(253, I253Codes),
	list__condense([I253Codes], Splits).
bytecode_to_intlist(rl_PROC_setschema(X0int32),	 Splits) :-
	int16_to_bytecode(254, I254Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I254Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_settemprel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(255, I255Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	list__condense([I255Codes,X0int32Codes,X1aStringCodes,X2aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_createtemprel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(256, I256Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	list__condense([I256Codes,X0int32Codes,X1aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_nametemprel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(257, I257Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	list__condense([I257Codes,X0int32Codes,X1aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_openpermrel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(258, I258Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	list__condense([I258Codes,X0int32Codes,X1aStringCodes,X2aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_createpermrel(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(259, I259Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	list__condense([I259Codes,X0int32Codes,X1aStringCodes,X2aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_addindextorel(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(260, I260Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	list__condense([I260Codes,X0int32Codes,X1aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_addindextoschema(X0int32),	 Splits) :-
	int16_to_bytecode(261, I261Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I261Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_clear(X0int32),	 Splits) :-
	int16_to_bytecode(262, I262Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I262Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_drop(X0int32),	 Splits) :-
	int16_to_bytecode(263, I263Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I263Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_dropindex(X0int32),	 Splits) :-
	int16_to_bytecode(264, I264Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I264Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_begintransaction(X0aString,X1int32),	 Splits) :-
	int16_to_bytecode(265, I265Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I265Codes,X0aStringCodes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_savepoint(X0int32),	 Splits) :-
	int16_to_bytecode(266, I266Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I266Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_rollback(X0int32),	 Splits) :-
	int16_to_bytecode(267, I267Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I267Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_commit,	 Splits) :-
	int16_to_bytecode(268, I268Codes),
	list__condense([I268Codes], Splits).
bytecode_to_intlist(rl_PROC_abort,	 Splits) :-
	int16_to_bytecode(269, I269Codes),
	list__condense([I269Codes], Splits).
bytecode_to_intlist(rl_PROC_delete(X0int32),	 Splits) :-
	int16_to_bytecode(270, I270Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I270Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_insert(X0int32),	 Splits) :-
	int16_to_bytecode(271, I271Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I271Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_bind_code(X0int32),	 Splits) :-
	int16_to_bytecode(272, I272Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I272Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_bind_handle(X0int32),	 Splits) :-
	int16_to_bytecode(273, I273Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I273Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_call(X0aString),	 Splits) :-
	int16_to_bytecode(274, I274Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list__condense([I274Codes,X0aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_label(X0int32),	 Splits) :-
	int16_to_bytecode(275, I275Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I275Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_goto(X0int32),	 Splits) :-
	int16_to_bytecode(276, I276Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I276Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_conditional_goto(X0int32),	 Splits) :-
	int16_to_bytecode(277, I277Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I277Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_goto_label(X0int32),	 Splits) :-
	int16_to_bytecode(278, I278Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I278Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_conditional_goto_label(X0int32),	 Splits) :-
	int16_to_bytecode(279, I279Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I279Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_notempty,	 Splits) :-
	int16_to_bytecode(280, I280Codes),
	list__condense([I280Codes], Splits).
bytecode_to_intlist(rl_PROC_empty,	 Splits) :-
	int16_to_bytecode(281, I281Codes),
	list__condense([I281Codes], Splits).
bytecode_to_intlist(rl_PROC_one_reference(X0int32),	 Splits) :-
	int16_to_bytecode(282, I282Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I282Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_is_permanent(X0int32),	 Splits) :-
	int16_to_bytecode(283, I283Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I283Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_has_index(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(284, I284Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	list__condense([I284Codes,X0int32Codes,X1aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_and,	 Splits) :-
	int16_to_bytecode(285, I285Codes),
	list__condense([I285Codes], Splits).
bytecode_to_intlist(rl_PROC_or,	 Splits) :-
	int16_to_bytecode(286, I286Codes),
	list__condense([I286Codes], Splits).
bytecode_to_intlist(rl_PROC_not,	 Splits) :-
	int16_to_bytecode(287, I287Codes),
	list__condense([I287Codes], Splits).
bytecode_to_intlist(rl_PROC_stream,	 Splits) :-
	int16_to_bytecode(288, I288Codes),
	list__condense([I288Codes], Splits).
bytecode_to_intlist(rl_PROC_stream_end,	 Splits) :-
	int16_to_bytecode(289, I289Codes),
	list__condense([I289Codes], Splits).
bytecode_to_intlist(rl_PROC_stream_list_cons,	 Splits) :-
	int16_to_bytecode(290, I290Codes),
	list__condense([I290Codes], Splits).
bytecode_to_intlist(rl_PROC_stream_list_nil,	 Splits) :-
	int16_to_bytecode(291, I291Codes),
	list__condense([I291Codes], Splits).
bytecode_to_intlist(rl_PROC_var(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(292, I292Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I292Codes,X0int32Codes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_indexed_var(X0int32,X1int32,X2aString),	 Splits) :-
	int16_to_bytecode(293, I293Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	list__condense([I293Codes,X0int32Codes,X1int32Codes,X2aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_var_list_cons(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(294, I294Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I294Codes,X0int32Codes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_var_list_nil,	 Splits) :-
	int16_to_bytecode(295, I295Codes),
	list__condense([I295Codes], Splits).
bytecode_to_intlist(rl_PROC_expr(X0int32),	 Splits) :-
	int16_to_bytecode(296, I296Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I296Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_expr_frag(X0int32),	 Splits) :-
	int16_to_bytecode(297, I297Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I297Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_expr_end,	 Splits) :-
	int16_to_bytecode(298, I298Codes),
	list__condense([I298Codes], Splits).
bytecode_to_intlist(rl_PROC_expr_list_cons(X0int32),	 Splits) :-
	int16_to_bytecode(299, I299Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I299Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_expr_list_nil,	 Splits) :-
	int16_to_bytecode(300, I300Codes),
	list__condense([I300Codes], Splits).
bytecode_to_intlist(rl_PROC_bool_op_list_cons,	 Splits) :-
	int16_to_bytecode(301, I301Codes),
	list__condense([I301Codes], Splits).
bytecode_to_intlist(rl_PROC_bool_op_list_nil,	 Splits) :-
	int16_to_bytecode(302, I302Codes),
	list__condense([I302Codes], Splits).
bytecode_to_intlist(rl_PROC_int_list_cons(X0int32),	 Splits) :-
	int16_to_bytecode(303, I303Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I303Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_int_list_nil,	 Splits) :-
	int16_to_bytecode(304, I304Codes),
	list__condense([I304Codes], Splits).
bytecode_to_intlist(rl_PROC_ret,	 Splits) :-
	int16_to_bytecode(305, I305Codes),
	list__condense([I305Codes], Splits).
bytecode_to_intlist(rl_PROC_join,	 Splits) :-
	int16_to_bytecode(306, I306Codes),
	list__condense([I306Codes], Splits).
bytecode_to_intlist(rl_PROC_join_nl,	 Splits) :-
	int16_to_bytecode(307, I307Codes),
	list__condense([I307Codes], Splits).
bytecode_to_intlist(rl_PROC_join_sm,	 Splits) :-
	int16_to_bytecode(308, I308Codes),
	list__condense([I308Codes], Splits).
bytecode_to_intlist(rl_PROC_join_hj,	 Splits) :-
	int16_to_bytecode(309, I309Codes),
	list__condense([I309Codes], Splits).
bytecode_to_intlist(rl_PROC_join_index_simple(X0int32),	 Splits) :-
	int16_to_bytecode(310, I310Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I310Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_join_index_complex,	 Splits) :-
	int16_to_bytecode(311, I311Codes),
	list__condense([I311Codes], Splits).
bytecode_to_intlist(rl_PROC_join_cross,	 Splits) :-
	int16_to_bytecode(312, I312Codes),
	list__condense([I312Codes], Splits).
bytecode_to_intlist(rl_PROC_semijoin_nl,	 Splits) :-
	int16_to_bytecode(313, I313Codes),
	list__condense([I313Codes], Splits).
bytecode_to_intlist(rl_PROC_semijoin_sm,	 Splits) :-
	int16_to_bytecode(314, I314Codes),
	list__condense([I314Codes], Splits).
bytecode_to_intlist(rl_PROC_semijoin_hj,	 Splits) :-
	int16_to_bytecode(315, I315Codes),
	list__condense([I315Codes], Splits).
bytecode_to_intlist(rl_PROC_semijoin_index(X0int32,X1int32),	 Splits) :-
	int16_to_bytecode(316, I316Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1int32, X1int32Codes),
	list__condense([I316Codes,X0int32Codes,X1int32Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract,	 Splits) :-
	int16_to_bytecode(317, I317Codes),
	list__condense([I317Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract_nl,	 Splits) :-
	int16_to_bytecode(318, I318Codes),
	list__condense([I318Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract_sm,	 Splits) :-
	int16_to_bytecode(319, I319Codes),
	list__condense([I319Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract_hj,	 Splits) :-
	int16_to_bytecode(320, I320Codes),
	list__condense([I320Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract_index(X0int32),	 Splits) :-
	int16_to_bytecode(321, I321Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I321Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_subtract_cross,	 Splits) :-
	int16_to_bytecode(322, I322Codes),
	list__condense([I322Codes], Splits).
bytecode_to_intlist(rl_PROC_semisubtract_nl,	 Splits) :-
	int16_to_bytecode(323, I323Codes),
	list__condense([I323Codes], Splits).
bytecode_to_intlist(rl_PROC_semisubtract_hj,	 Splits) :-
	int16_to_bytecode(324, I324Codes),
	list__condense([I324Codes], Splits).
bytecode_to_intlist(rl_PROC_semisubtract_index(X0int32),	 Splits) :-
	int16_to_bytecode(325, I325Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I325Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_difference,	 Splits) :-
	int16_to_bytecode(326, I326Codes),
	list__condense([I326Codes], Splits).
bytecode_to_intlist(rl_PROC_select,	 Splits) :-
	int16_to_bytecode(327, I327Codes),
	list__condense([I327Codes], Splits).
bytecode_to_intlist(rl_PROC_select_filter,	 Splits) :-
	int16_to_bytecode(328, I328Codes),
	list__condense([I328Codes], Splits).
bytecode_to_intlist(rl_PROC_select_index(X0int32),	 Splits) :-
	int16_to_bytecode(329, I329Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I329Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_btree_scan(X0int32),	 Splits) :-
	int16_to_bytecode(330, I330Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I330Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_project_tee,	 Splits) :-
	int16_to_bytecode(331, I331Codes),
	list__condense([I331Codes], Splits).
bytecode_to_intlist(rl_PROC_sort(X0int32),	 Splits) :-
	int16_to_bytecode(332, I332Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I332Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_PROC_union,	 Splits) :-
	int16_to_bytecode(333, I333Codes),
	list__condense([I333Codes], Splits).
bytecode_to_intlist(rl_PROC_union_sm,	 Splits) :-
	int16_to_bytecode(334, I334Codes),
	list__condense([I334Codes], Splits).
bytecode_to_intlist(rl_PROC_uniondiff,	 Splits) :-
	int16_to_bytecode(335, I335Codes),
	list__condense([I335Codes], Splits).
bytecode_to_intlist(rl_PROC_uniondiff_sm,	 Splits) :-
	int16_to_bytecode(336, I336Codes),
	list__condense([I336Codes], Splits).
bytecode_to_intlist(rl_PROC_uniondiff_btree,	 Splits) :-
	int16_to_bytecode(337, I337Codes),
	list__condense([I337Codes], Splits).
bytecode_to_intlist(rl_PROC_aggregate,	 Splits) :-
	int16_to_bytecode(338, I338Codes),
	list__condense([I338Codes], Splits).
bytecode_to_intlist(rl_PROC_aggregate_sm,	 Splits) :-
	int16_to_bytecode(339, I339Codes),
	list__condense([I339Codes], Splits).
bytecode_to_intlist(rl_PROC_aggregate_onegroup,	 Splits) :-
	int16_to_bytecode(340, I340Codes),
	list__condense([I340Codes], Splits).
bytecode_to_intlist(rl_PROC_insert_tuple_stream,	 Splits) :-
	int16_to_bytecode(341, I341Codes),
	list__condense([I341Codes], Splits).
bytecode_to_intlist(rl_PROC_empty_stream(X0aString),	 Splits) :-
	int16_to_bytecode(342, I342Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	list__condense([I342Codes,X0aStringCodes], Splits).
bytecode_to_intlist(rl_PROC_hypothetical,	 Splits) :-
	int16_to_bytecode(343, I343Codes),
	list__condense([I343Codes], Splits).
bytecode_to_intlist(rl_PROC_topdown,	 Splits) :-
	int16_to_bytecode(344, I344Codes),
	list__condense([I344Codes], Splits).
bytecode_to_intlist(rl_PROC_last_bytecode,	 Splits) :-
	int16_to_bytecode(345, I345Codes),
	list__condense([I345Codes], Splits).
bytecode_to_intlist(rl_HEAD_proc(X0aString,X1aString,X2aString,X3int32),	 Splits) :-
	int16_to_bytecode(346, I346Codes),
	int32_to_bytecode(X0aString, X0aStringCodes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	int32_to_bytecode(X3int32, X3int32Codes),
	list__condense([I346Codes,X0aStringCodes,X1aStringCodes,X2aStringCodes,X3int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_proc_end,	 Splits) :-
	int16_to_bytecode(347, I347Codes),
	list__condense([I347Codes], Splits).
bytecode_to_intlist(rl_HEAD_const_int(X0int32,X1aInt),	 Splits) :-
	int16_to_bytecode(348, I348Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aInt_to_bytecode(X1aInt, X1aIntCodes),
	list__condense([I348Codes,X0int32Codes,X1aIntCodes], Splits).
bytecode_to_intlist(rl_HEAD_const_flt(X0int32,X1aDouble),	 Splits) :-
	int16_to_bytecode(349, I349Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aDouble_to_bytecode(X1aDouble, X1aDoubleCodes),
	list__condense([I349Codes,X0int32Codes,X1aDoubleCodes], Splits).
bytecode_to_intlist(rl_HEAD_const_str(X0int32,X1aString),	 Splits) :-
	int16_to_bytecode(350, I350Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	aString_to_bytecode(X1aString, X1aStringCodes),
	list__condense([I350Codes,X0int32Codes,X1aStringCodes], Splits).
bytecode_to_intlist(rl_HEAD_var_int(X0int32),	 Splits) :-
	int16_to_bytecode(351, I351Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I351Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_var_flt(X0int32),	 Splits) :-
	int16_to_bytecode(352, I352Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I352Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_var_str(X0int32),	 Splits) :-
	int16_to_bytecode(353, I353Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I353Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_var_term(X0int32),	 Splits) :-
	int16_to_bytecode(354, I354Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I354Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_var_stream(X0int32),	 Splits) :-
	int16_to_bytecode(355, I355Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	list__condense([I355Codes,X0int32Codes], Splits).
bytecode_to_intlist(rl_HEAD_define_rule(X0int32,X1aString,X2aString),	 Splits) :-
	int16_to_bytecode(356, I356Codes),
	int32_to_bytecode(X0int32, X0int32Codes),
	int32_to_bytecode(X1aString, X1aStringCodes),
	int32_to_bytecode(X2aString, X2aStringCodes),
	list__condense([I356Codes,X0int32Codes,X1aStringCodes,X2aStringCodes], Splits).
bytecode_to_intlist(rl_HEAD_last_bytecode,	 Splits) :-
	int16_to_bytecode(357, I357Codes),
	list__condense([I357Codes], Splits).

int32_to_bytecode(X, List) :-
	int32_to_byte_list(X, List).

int16_to_bytecode(X, List) :-
	short_to_byte_list(X, List).

aString_to_bytecode(Str, Ints) :-
	string_to_byte_list(Str, Ints).

aDouble_to_bytecode(Flt, List) :-
	float_to_byte_list(Flt, List).

aBlob_to_bytecode(_Blob, [0]).	% NYI

aInt_to_bytecode(X, List) :-
	int_to_byte_list(X, List).


rl_code__version(1, 27).
