#ifndef LIBBTUTIL_TYPES_BT_LLIST
#define LIBBTUTIL_TYPES_BT_LLIST

#include <apr.h>
#include <apr_pools.h>
#include <stdint.h>

typedef struct bt_llist_s bt_llist;
typedef struct bt_llist_e_s bt_llist_e;

struct bt_llist_e_s {
    apr_size_t          s;
    void*               d;
    bt_llist*           l;
    bt_llist_e*         next;
    bt_llist_e*         prev;
    int                 ln;
};

struct bt_llist_s {
    apr_pool_t*         p;
    uint32_t            n;
    uint32_t            max;            /* 0 = unlimited */
    bt_llist_e*         first;
    bt_llist_e*         last;
};

extern bt_llist* bt_llist_new(apr_pool_t* p, uint32_t max);
extern void bt_llist_destroy(bt_llist* list);
extern bt_llist_e* bt_llist_e_new(bt_llist* list, void* data, apr_size_t size);
extern void bt_llist_e_unlink(bt_llist_e* e);
extern apr_status_t bt_llist_e_link_first(bt_llist_e* e);
extern apr_status_t bt_llist_e_link_last(bt_llist_e* e);
extern apr_status_t bt_llist_e_link_before(bt_llist_e* e, bt_llist_e* before);
extern apr_status_t bt_llist_e_link_after(bt_llist_e* e, bt_llist_e* after);

extern apr_status_t bt_llist_add_last(bt_llist* l, void* data, apr_size_t len);
extern apr_status_t bt_llist_add_first(
    bt_llist* l, void* data, apr_size_t len
);
extern apr_status_t bt_llist_add_before(
    bt_llist* l, bt_llist_e* before, void* data, apr_size_t len
);
extern apr_status_t bt_llist_add_after(
    bt_llist* l, bt_llist_e* after, void* data, apr_size_t len
);

#endif /* LIBBTUTIL_TYPES_BT_LLIST */
