#ifndef LIBBTUTIL_UTIL_H
#define LIBBTUTIL_UTIL_H

/* libc */
#include <string.h>
/* other libs */
#include <apr.h>
#include <apr_pools.h>
#include <apr_network_io.h>

/* local */
#include <libbtutil/const.h>
#include <libbtutil/util/sha1.h>
#include <libbtutil/util/http_get.h>

/* www.c */

typedef struct bt_form_pair_s {	/* form key/value pairs */
    char        key[33];
    char        value[129];
    apr_size_t  value_len;
    char*       eop;            /* pointer to end of form pair in a string */
} bt_form_pair;

extern bt_form_pair bt_next_form_pair_unesc(char* str);
extern bt_form_pair bt_next_form_pair(char* str);
extern apr_size_t bt_uri_unescape(char* p);
extern char* bt_uri_escape(apr_pool_t*p, char*str, int len);

/* bt_random_seed.c */
extern int bt_random_seed();

/* bt_str_hash.c */
extern char* bt_hash_str(apr_pool_t* p, char* data, apr_size_t data_len);

extern char* bt_str_hash(apr_pool_t* p, char* data, apr_size_t data_len);
extern char* bt_str_esc_hash(apr_pool_t* p, char* data, apr_size_t data_len);

#define bt_infohash_str(p, data) bt_hash_str(p, data, BT_INFOHASH_LEN)
#define bt_peerid_str(p, data) bt_hash_str(p, data, BT_INFOHASH_LEN)

#define bt_str_peerid(p, data) bt_str_hash(p, data, BT_PEERID_LEN)
#define bt_str_infohash(p, data) bt_str_hash(p, data, BT_INFOHASH_LEN)

#define bt_str_esc_peerid(p, data) bt_str_esc_hash(p, data, BT_PEERID_LEN)
#define bt_str_esc_infohash(p, data) bt_str_esc_hash(p, data, BT_INFOHASH_LEN)

/* bt_nice_size.c */
extern char* bt_nice_size(apr_pool_t* p, bt_off_t size);

/* bt_strfunixtime.c */
extern char* bt_strfunixtime(
    apr_pool_t* p, const char* format, time_t unixtime
);

extern char* bt_strinterval(apr_pool_t* p, int interval);

#define bt_nice_date(a, b) bt_strfunixtime(a, BT_NICE_DATE, b)

/* strcat_utf8.c */
extern char* bt_strcat_utf8(apr_pool_t* pool, char* s, char* append);

/* bt_str_url.c */
extern char* bt_args2url(
    apr_pool_t* p, const char* addr, apr_port_t port, const char* path
);
extern apr_status_t bt_url2args(
    const char* url, char* addr, apr_port_t* port, char* path
);

#endif /* LIBBTUTIL_UTIL_H */
