/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"
#include "auth.h"

/* This file contains code to autheticate for anonymous users */

typedef struct 
{
	struct passwd *passent;
	FTPSTATE *peer;
} PASSWDSTRUCT;

void *anonauth_gethandle(FTPSTATE *peer, TOKENSET *tset, char *username, int *err)
{
	PASSWDSTRUCT *newhandle;
	char *anonuser;
	
	newhandle = mallocwrapper(sizeof(PASSWDSTRUCT));
	
	anonuser = mktokconfstr(tset, auth_getcursectionid(peer), "anonymous_user", "ftp");
	
	newhandle->passent = getpwnam(anonuser);
	if (newhandle->passent == NULL)
		goto error;
	
	newhandle->peer = peer;
	*err = AUTH_OK;
	freewrapper(anonuser);
	return(newhandle);

error:
	*err = AUTH_ERROR;
	log_giveentry(MYLOG_INFO, peer, safe_snprintf("Could not find user '%s' in password file. Cancelling anonymous authentication.", anonuser)); 
	freewrapper(anonuser);
	freewrapper(newhandle);
	return(NULL);
}

void anonauth_freehandle(void *handle)
{
	freewrapper(handle);
}

int anonauth_checkpasswd(void *h, char *password, char **errmsg)
{
	log_giveentry(MYLOG_LOGIN, ((PASSWDSTRUCT *)h)->peer, safe_snprintf("anonymous password '%s'", password));
	return(TRUE);
}

char *anonauth_getrootdir(void *h)
{
	return(((PASSWDSTRUCT *)h)->passent->pw_dir);
}

char *anonauth_gethomedir(void *h)
{
	return("/");
}

uid_t anonauth_getuseruid(void *h)
{
	return(config->uidt_nobodyuid);
}

gid_t anonauth_getusergid(void *h)
{
	return(config->gidt_nobodygid);
}

PERMSTRUCT anonauth_commands =
{
	anonauth_checkpasswd,
	anonauth_gethomedir,
	anonauth_getrootdir,
	anonauth_getuseruid,
	anonauth_getusergid,
	NULL,
	anonauth_gethandle,
	anonauth_freehandle,
	NULL,
};
