# playmp3.py - replace the core MP3 file class with one that allows playback.
#
#  Copyright 2004 Daniel Burrows

from musiclibrarian import musicfile
from musiclibrarian import plugins
import mad

id3file=plugins.load_plugin('id3file')

class PlayableMP3File(id3file.ID3File):
    def get_file(self):
        class MP3Reader:
            def __init__(self, mf):
                self.mf=mf

            def read(self, amt=-1):
                buf=self.mf.read(amt)

                if self.mf.mode() == mad.MODE_SINGLE_CHANNEL:
                    channels=1
                else:
                    channels=2

                if buf == None:
                    amt=None
                else:
                    amt=len(buf)

                return buf,amt,self.mf.samplerate(),16,channels

        return MP3Reader(mad.MadFile(self.fn))

musicfile.register_file_type('mp3', PlayableMP3File)
