#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10788);
 name["english"] = "Solaris finger disclosure";
 script_name(english:name["english"]);
 
 desc["english"] = "There is a bug in the finger service
which will make it display the list of the accounts that
have never been used, when anyone issues the request :

		finger 'a b c d e f g h'@target
		
This list will help an attacker to guess the operating
system type. It will also tell him which accounts have
never been used, which will often make him focus his
attacks on these accounts.

Solution : disable the finger service in /etc/inetd.conf, or
apply the patches from Sun.

Risk factor : Medium";

 desc["francais"] = "Il y a un bug dans le service
finger qui lui fait afficher la liste des 
comptes qui n'ont jamais t utiliss, quand
quelqu'un fait la requte :

		finger 'a b c d e f g h'@victime
		
Cette liste va permettre  un pirate de deviner le
type de systme d'exploitation de la victime. Il
va aussi lui dire quels comptes n'ont jamais
t utiliss, ce qui lui fera souvent se concentrer
sur ceux-ci.

Solution : dsactivez le service finger dans /etc/inetd.conf
ou appliquez les patches de Sun

Facteur de risque : Moyen";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Enumerates users with finger";
 summary["francais"] = "Enumerates users with finger";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Finger abuses";
 family["francais"] = "Abus de finger";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/finger", 79);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/finger");
if(!port)port = 79;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buf = string("a b c d e f g h\r\n");
  send(socket:soc, data:buf);
  data = recv(socket:soc, length:2048);
  close(soc);
  if(("daemon" >< data) && ("root" >< data) && ("nobody" >< data))security_warning(port);
 }
}
