/****************************************************************************/
/* ##   ##         #####   #####  ##     **      NoSQL RDBMS - hashdir      */
/* ###  ##        ####### ####### ##     **        $Revision: 1.1.1.1 $       */
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **   Carlo Strozzi (c) 1998-2000   */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **        Maurizio Sartori         */
/* ##   ##  ####   #####   #### # ###### **    e-mail: masar@mi.linux.it    */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/****************************************************************************

   Takes a string on the command line and prints its hashed value in the
   form of 'directory/subdirectory' string. This can be useful to uniformly
   distribute table files in the file-system. If '-' is specified in place
   of the string parameter, then the value(s) to be hashed is read from
   stdin.

   Usage:  nosql hashdir [-f] -|string

****************************************************************************/

#include <stdio.h>
#include <unistd.h>

static void make_hash (const char * pName, int iFull)
   {
   unsigned long ulHash;
   const char achChars[] = "abcdefghijklmnopqrstuvwxyz123456";
   char achPath[1000];
   int i;
   const char * pcPtr = pName;
   char * pPtr;
   
   ulHash = 0;
   for (i = 0; i < 25; i++)
      {
      ulHash ^= (((unsigned long)*pcPtr) << 8) | (*pcPtr);
      ulHash <<= 1;
      pcPtr = (*pcPtr == 0) ? pName : pcPtr+1;
      }
      
   pPtr = achPath;
//   *pPtr++ = achChars[(ulHash & 0x7c000000) >> 26];
//   *pPtr++ = achChars[(ulHash & 0x03e00000) >> 21];
//   *pPtr++ = '/';
   *pPtr++ = achChars[(ulHash & 0x001f0000) >> 16];
   *pPtr++ = achChars[(ulHash & 0x0000f800) >> 11];
   *pPtr++ = '/';
   *pPtr++ = achChars[(ulHash & 0x000007c0) >> 6];
   *pPtr++ = achChars[(ulHash & 0x0000003e) >> 1];

   if (iFull)
      {
      pcPtr = pName;
      *pPtr++ = '/';
      while (*pcPtr)
         {
         *pPtr++ = *pcPtr++;
         }
      }
   *pPtr++ = '\n';
   write (1, achPath, pPtr-achPath);
   }
   
int main (int argc, char * argv [])
   {
   /* char * pPtr; */
   /* char * pPtr1; */
   int iFull = 0;
   char achPath[1000];

   if ((argc > 1) &&
       (argv[1][0] == '-') && 
       (argv[1][1] == 'f') &&
       (argv[1][2] == 0))
      {
      iFull = 1;
      argc--;
      argv++;
      }
      
   if (argc == 1)
      {
      fprintf (stderr, "Usage: nosql hashdir [-f] -|string\n"); 
      return (1);
      }
   
   if (argv[1][0] != '-')
      {   
      make_hash (argv[1], iFull);
      }
   else
      {
      while (fgets (achPath, 900, stdin))
         {
         achPath[strlen(achPath)-1] = 0;
         make_hash (achPath, iFull);
         }
      }

   return (0);
   }

/* End of program */
