/*
**  MimeUtility.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**          Alexander Malmberg <alexander@malmberg.org>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>
#import <AppKit/NSFileWrapper.h>

#import <Pantomime/Charset.h>

@class Message;
@class MimeMultipart;
@class Part;

@class NSFileWrapper;


@interface MimeUtility: NSObject

+ (int) stringEncodingForCharset: (NSData *) charset;

+ (NSString *) stringValueOfTransferEncoding: (int) theEncoding;


//
// Decode a header encoded according to RFC2047
//
+ (NSString *) decodeHeader: (NSData *) theData;


//
// Also handles soft line-breaks
//
+ (NSData *) decodeQuotedPrintable: (NSData *) theData
			  inHeader: (BOOL)h;


+ (NSData *) decodeBase64: (NSData *) theData;


+ (NSString *) stringWithData: (NSData *) theData
                      charset: (NSData *) theCharset;


+ (NSData *) unfoldLinesFromData: (NSData *) theData;


//
// linelenght of 0 disables wrapping
//
+ (NSData *) encodeBase64: (NSData *) theData
                lineLength: (int) numChars;

//
// linelenght of 0 disables wrapping
// 
+ (NSData *) encodeQuotedPrintable: (NSData *) theData
			lineLength: (int) numChars
			  inHeader: (BOOL)h;


+ (NSData *) encodeHeader: (NSString *) theText;

+ (NSData *) encodeHeader: (NSString *) theText
             usingCharset: (NSString *) theCharset
                 encoding: (int) encoding;


+ (NSData *) encodeWordUsingBase64: (NSString *) theWord
                      prefixLength: (int) thePrefixLength;

+ (NSData *) encodeWordUsingQuotedPrintable: (NSString *) theWord
                               prefixLength: (int) thePrefixLength;


+ (NSData *) generateBoundary;
+ (NSData *) generateOSID;


+ (Charset *) charsetForName: (NSString *) theName;
+ (NSString *) charsetForString: (NSString *) theString;


//
// FIXME
//+ (NSString *) foldStringUsingSoftLineBreaks: (NSString *) theString
//                                      length: (int) theLength;
//


+ (BOOL) isASCIIString: (NSString *) theString;


+ (NSString*) _breakWord: (NSString *) theWord
              usingLimit: (int) theLimit;

+ (NSString *) unwrapPlainTextString: (NSString *) theString
             usingQuoteWrappingLimit: (int) theQuoteLimit;

+ (NSString *) wrapPlainTextString: (NSString *) theString
                usingWrappingLimit: (int) theLimit;

+ (NSString *) quotePlainTextString: (NSString *) theString
                         quoteLevel: (int) theLevel
                      wrappingLimit: (int) theLimit;


+ (Message *) compositeMessageContentFromRawSource: (NSData *) theData;


+ (MimeMultipart *) compositeMultipartContentFromRawSource: (NSData *) theData
                                             usingBoundary: (NSData *) theBoundary;


+ (id) discreteContentFromRawSource: (NSData *) theData
       usingContentTransferEncoding: (int) theContentTransferEncoding
                            charset: (NSString *) theCharset
                               part: (Part *) thePart;

+ (void) setContentFromRawSource: (NSData *) theData
                          inPart: (Part *) thePart;


+ (NSFileWrapper *) fileWrapperFromUUEncodedString: (NSString *) theString;

+ (NSRange) rangeOfUUEncodedStringFromString: (NSString *) theString
                                       range: (NSRange) theRange;


@end

