/*
**  TestCase.h
**
**  This is a small and simple (but useful) test framework.
**
**  Copyright (c) 2001, 2002
**
**  Author:  Alexander Malmberg <alexander@malmberg.org>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  
*/

#ifndef TestCase_h
#define TestCase_h

#include <Foundation/NSString.h>

@interface TestCase : NSObject
{
  const char *name;
  SEL sel;
}

- (id) initWithName: (const char *)name;
- (void) runTest;

+(void) runTestWithName: (const char *)name;


-(void) objectIsKindOf: (Class)c : (id)o;

-(void) equalInt: (int)expected : (int)got;
-(void) equalInt: (int)expected : (int)got  msg: (NSString *)msg;

-(void) equalUnichar: (unichar)expected : (unichar)got;
-(void) equalUnichar: (unichar)expected : (unichar)got  msg: (NSString *)msg;

-(void) equalString: (NSString *)expected : (NSString *)got;
//-(void) equalString: (NSString *)expected : (NSString *)got  msg: (NSString *)msg;
-(void) equalData: (NSData *)expected : (NSData *)got;
//-(void) equalData: (NSData *)expected : (NSData *)got  msg: (NSString *)msg;

@end

#endif

