/*
 * dialog.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_DIALOG_H
#define PDFCHAIN_DIALOG_H

#include "pdfchain.h"


/*** About Dialog  ************************************************************/

class
cDialog_About : public Gtk::AboutDialog
{
	public:

		cDialog_About();
		virtual ~cDialog_About();
};



/*** Message Dialog : PDFTK Error *********************************************/

class
cMDialog_PdftkError : public Gtk::MessageDialog
{
	public:
		cMDialog_PdftkError( Gtk::Window& );
		virtual ~cMDialog_PdftkError();

		void popupMessage( const Glib::ustring& , int );
		
	protected:
};



/*** Message Dialog : Password ( used at mLStore_Cat::addPages() ) ************/

class
cMDialog_Password : public Gtk::MessageDialog
{
	public:

		cMDialog_Password( Gtk::Window& );
		virtual ~cMDialog_Password();

		void			init( const std::string& , const Glib::ustring& );
		Glib::ustring	getCorrectPassword( const Glib::ustring& );
		
	protected:

		bool			bChecked;
		Glib::ustring	sPassword;

		Gtk::Table				mTable;
		Gtk::RadioButton		mRButton_PasswordNone,
								mRButton_PasswordNew,
								mRButton_PasswordOrg,
								mRButton_PasswordAlt;
		Gtk::RadioButtonGroup	mRBGroup_Password;
		Gtk::Label				mLabel_PasswordNew,
								mLabel_PasswordOrg,
								mLabel_FileName;
		Gtk::Entry				mEntry_PasswordAlt;

		void onEntryIcon_PasswordAlt_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_PasswordAlt.set_text("");
			return;
		}
};


#endif