/*
 * store.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_STORE_H
#define PDFCHAIN_WINDOW_STORE_H

#include "pdfchain.h"


/*** Tree Model Column Record : Selection *************************************/

class
cTMCRecord_Selection : public Gtk::TreeModel::ColumnRecord
{
	public:

		cTMCRecord_Selection();
		virtual ~cTMCRecord_Selection();
		
		Gtk::TreeModelColumn<guchar>		mTMColumn_ID;
		Gtk::TreeModelColumn<Glib::ustring>	mTMColumn_Label;
		Gtk::TreeModelColumn<std::string>	mTMColumn_Command;
};



/*** ListStore : Output ID ****************************************************/

class
cLStore_OutputID : public Gtk::ListStore
{
	public:

		cLStore_OutputID();
		virtual ~cLStore_OutputID();

		static Glib::RefPtr<cLStore_OutputID> create();
		cTMCRecord_Selection* getTMCRecord();

		Gtk::TreeModel::iterator setMultipleFiles( guchar output_id );
		Gtk::TreeModel::iterator setSingleFile();
		
	protected:
		
		cTMCRecord_Selection* pTMCRecord;

		void removeRows();
};


/*** ListStore : Even Odd *****************************************************/

class
cLStore_EvenOdd : public Gtk::ListStore
{
	public:

		cLStore_EvenOdd();
		virtual ~cLStore_EvenOdd();

		static Glib::RefPtr<cLStore_EvenOdd> create();
		cTMCRecord_Selection* getTMCRecord();

	protected:

		cTMCRecord_Selection* pTMCRecord;
};



/*** ListStore : Rotation *****************************************************/

class
cLStore_Rotation : public Gtk::ListStore
{
	public:

		cLStore_Rotation();
		virtual ~cLStore_Rotation();

		static Glib::RefPtr<cLStore_Rotation> create();
		cTMCRecord_Selection* getTMCRecord();

	protected:
		
		cTMCRecord_Selection* pTMCRecord;
};



/*** ListStore : Counting Methode *********************************************/

class
cLStore_CountingMethode : public Gtk::ListStore
{
	public:

		cLStore_CountingMethode();
		virtual ~cLStore_CountingMethode();

		static Glib::RefPtr<cLStore_CountingMethode> create();
		cTMCRecord_Selection* getTMCRecord();

	protected:
		
		cTMCRecord_Selection* pTMCRecord;
};


#endif