#!/usr/bin/python
"""
Extension to send Email
"""
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: mailtowrapper.py 82 2004-07-11 13:01:44Z henning $

import sys
import os
import Preferences

def mailto(recipient):
    # recipient should be a string like: 'Henning Jacobs <henning@srcco.de>'
    mailprog = Preferences.get("client.mailto_program")
    if sys.platform == 'win32':
        if not mailprog:
            # Get default mail-application from Windows-Registry:
            import _winreg
            handle = _winreg.OpenKey(_winreg.HKEY_LOCAL_MACHINE,
                'SOFTWARE\Classes\mailto\shell\open\command')
            valname, mailprog, valtype = _winreg.EnumValue(handle, 0)
        args = mailprog.split(' ')
        # Remove dbl-quotes if any:
        if args[0][0] == '"' and args[0][-1] == '"':
            args[0] = args[0][1:-1]
        args[0] = os.path.abspath(args[0])    
        for i in range(1, len(args)):
            args[i] = args[i].replace('%1', recipient)
        os.spawnv(os.P_NOWAIT, args[0], args)
    else:
        if not mailprog:
            # Ugly fallback:
            # (xterm and mail should be available on every UNIX-machine):
            mailprog = 'xterm -e mail %1'
        args = mailprog.split(' ')
        for i in range(1, len(args)):
            args[i] = args[i].replace('%1', recipient)
        os.spawnvp(os.P_NOWAIT, args[0], args)

