#ifndef _SJOG_H
#define _SJOG_H 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <gtk/gtk.h>
#include <glib.h>

/* sony jog position */
#define JOG_BOTTOM 1
#define JOG_TOP 31
#define JOG_PUSHED 64

/* timeout for windows hide */
#define SJOG_TIMEOUT 3000

/* #define DEBUG */
#undef DEBUG


/* options */
extern gboolean reverseBrightness;
extern gboolean useSpic;
extern gboolean mousewheelFakeKeys;

/* modes */
guint currentMode;

typedef enum
{
   SJOG_MODE_LIST,
   SJOG_MODE_BRIGHTNESS,
   SJOG_MODE_VOLUME,
   SJOG_MODE_SCROLL
}
sjog_mode;

void sjog_set_mode(guint mode);
guint sjog_get_mode();

typedef struct sjog_cmd
{
   gchar *name;
   gchar *path;
}
sjog_cmd_t;


gboolean sjog_jog_posiiton_changed(gint jog);
void sjog_window_set_position(GtkWindow * window);

#endif
