#include "sjog_list_callbacks.h"

/* Hides the application.
 */
gint
sjog_list_signal_delete_event_callback(GtkWidget * widget, GdkEvent * event,
                                       gpointer * data)
{
#ifdef DEBUG
   fprintf(stdout, "sjog_list_signal_delete_event_callback\n");
#endif
   gtk_widget_hide_all(widget);

   return TRUE;
}

/* Callback called when a list item is selected.
 * Just keeps track of the selected item position.
 */
void
sjog_list_row_selected_callback(GtkWidget * widget, gint row, gint col,
                                GdkEventButton * event, gpointer * data)
{
#ifdef DEBUG
   fprintf(stdout, "sjog_list_row_selected: %d\n", row);
#endif
   selectedIndex = row;
}

int
sjog_list_timer_callback(gpointer * data)
{

#ifdef DEBUG
   fprintf(stdout, "sjog_list_timer_callback\n");
#endif

   sjog_list_hide();

   return FALSE;
}
