/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.event.AdjustmentEvent;
import swingwt.awt.event.AdjustmentListener;
import swingwt.awt.event.ComponentEvent;
import swingwt.awt.event.ComponentListener;
import swingwt.awt.event.ContainerEvent;
import swingwt.awt.event.ContainerListener;
import swingwtx.swing.JLabel;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollBar;
import swingwtx.swing.JViewport;
import swingwtx.swing.Scrollable;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.border.Border;

public class JScrollPane
extends JPanel
implements AdjustmentListener {
    public static final int VERTICAL_SCROLLBAR_ALWAYS = 0;
    public static final int VERTICAL_SCROLLBAR_AS_NEEDED = 1;
    public static final int VERTICAL_SCROLLBAR_NEVER = 2;
    public static final int HORIZONTAL_SCROLLBAR_ALWAYS = 3;
    public static final int HORIZONTAL_SCROLLBAR_AS_NEEDED = 4;
    public static final int HORIZONTAL_SCROLLBAR_NEVER = 5;
    public static final String VIEWPORT = "VIEWPORT";
    public static final String VERTICAL_SCROLLBAR = "VERTICAL_SCROLLBAR";
    public static final String HORIZONTAL_SCROLLBAR = "HORIZONTAL_SCROLLBAR";
    public static final String ROW_HEADER = "ROW_HEADER";
    public static final String COLUMN_HEADER = "COLUMN_HEADER";
    public static final String LOWER_LEFT_CORNER = "LOWER_LEFT_CORNER";
    public static final String LOWER_RIGHT_CORNER = "LOWER_RIGHT_CORNER";
    public static final String UPPER_LEFT_CORNER = "UPPER_LEFT_CORNER";
    public static final String UPPER_RIGHT_CORNER = "UPPER_RIGHT_CORNER";
    public static final String LOWER_LEADING_CORNER = "LOWER_LEADING_CORNER";
    public static final String LOWER_TRAILING_CORNER = "LOWER_TRAILING_CORNER";
    public static final String UPPER_LEADING_CORNER = "UPPER_LEADING_CORNER";
    public static final String UPPER_TRAILING_CORNER = "UPPER_TRAILING_CORNER";
    public static final String VERTICAL_SCROLLBAR_POLICY = "VERTICAL_SCROLLBAR_POLICY";
    public static final String HORIZONTAL_SCROLLBAR_POLICY = "HORIZONTAL_SCROLLBAR_POLICY";
    protected static final int BAR_SCALE_FACTOR = 10;
    protected int verticalPolicy = 1;
    protected int horizontalPolicy = 4;
    protected JScrollBar hbar = new JScrollBar(1);
    protected JScrollBar vbar = new JScrollBar(0);
    protected Component childComponent = null;
    protected JPanel northPanel = new JPanel();
    protected JPanel westPanel = new JPanel();
    protected JPanel southPanel = new JPanel();
    protected Component columnView = null;
    protected Component rowView = null;
    protected int ypix = 0;
    protected int xpix = 0;
    protected int showY = 0;
    protected int realY = 0;
    protected int diffY = 0;
    protected int showX = 0;
    protected int realX = 0;
    protected int diffX = 0;
    protected boolean deactivated = false;
    protected JViewport view = null;

    public JScrollPane() {
        this(null, 1, 4);
    }

    public JScrollPane(Component component) {
        this(component, 1, 4);
    }

    public JScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public JScrollPane(Component component, int vsbPolicy, int hsbPolicy) {
        this.verticalPolicy = vsbPolicy;
        this.horizontalPolicy = hsbPolicy;
        this.layoutScrollPane();
        this.setViewport(new JViewport());
        this.add(component);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                JScrollPane.this.calculateBarSize();
            }

            public void componentMoved(ComponentEvent e) {
                JScrollPane.this.calculateBarSize();
            }

            public void componentShown(ComponentEvent e) {
                JScrollPane.this.calculateBarSize();
            }

            public void componentHidden(ComponentEvent e) {
                JScrollPane.this.calculateBarSize();
            }
        });
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                JScrollPane.this.calculateBarSize();
            }

            public void componentRemoved(ContainerEvent e) {
                JScrollPane.this.calculateBarSize();
            }
        });
    }

    protected void layoutScrollPane() {
        this.setLayout(new BorderLayout());
        this.hbar.setUnitIncrement(1);
        this.vbar.setUnitIncrement(1);
        this.hbar.setBlockIncrement(5);
        this.vbar.setBlockIncrement(5);
        this.northPanel.setLayout(new BorderLayout());
        this.westPanel.setLayout(new BorderLayout());
        super.add((Component)this.northPanel, "North");
        super.add((Component)this.westPanel, "West");
        super.add((Component)this.hbar, "South");
        super.add((Component)this.vbar, "East");
        this.handleBarVisibility();
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
    }

    protected void handleBarVisibility() {
        if (this.deactivated) {
            this.vbar.setVisible(false);
            this.hbar.setVisible(false);
            return;
        }
        if (this.verticalPolicy == 0) {
            this.vbar.setVisible(true);
        } else if (this.verticalPolicy == 2) {
            this.vbar.setVisible(false);
        } else if (this.diffY > 0) {
            this.vbar.setVisible(true);
        } else {
            this.vbar.setVisible(false);
        }
        if (this.horizontalPolicy == 3) {
            this.hbar.setVisible(true);
        } else if (this.horizontalPolicy == 5) {
            this.hbar.setVisible(false);
        } else if (this.diffX > 0) {
            this.hbar.setVisible(true);
        } else {
            this.hbar.setVisible(false);
        }
        this.invalidate();
        this.repaint();
    }

    protected void calculateBarSize() {
        if (this.view != null && this.deactivated) {
            this.view.getComponent(0).setSize(this.getSize());
        }
        if (this.childComponent == null && this.view.getComponentCount() > 0) {
            this.childComponent = this.view.getComponent(0);
        }
        if (this.childComponent == null || this.deactivated) {
            return;
        }
        this.showY = this.getSize().height - this.hbar.getPeerSize().height;
        if (this.columnView != null) {
            this.showY -= this.columnView.getPeerSize().height;
        }
        Dimension childSize = this.calcChildSize();
        this.realY = childSize.height;
        this.diffY = this.realY - this.showY;
        this.vbar.setMinimum(0);
        this.vbar.setMaximum(this.diffY / 10);
        this.vbar.setValue(0);
        this.showX = this.getSize().width - this.vbar.getPeerSize().width;
        if (this.rowView != null) {
            this.showX -= this.rowView.getPeerSize().width;
        }
        this.realX = childSize.width;
        this.diffX = this.realX - this.showX;
        this.hbar.setMinimum(0);
        this.hbar.setMaximum(this.diffX / 10);
        this.hbar.setValue(0);
        this.handleBarVisibility();
    }

    public JViewport getViewport() {
        return this.view;
    }

    public void setViewport(JViewport view) {
        this.view = view;
        this.doAdd(view);
    }

    public void setViewportBorder(Border b) {
        this.setBorder(b);
    }

    public Border getViewportBorder() {
        return this.getBorder();
    }

    public Component add(Component c) {
        if (c == null) {
            return null;
        }
        this.checkIfComponentCanHandleItself(c);
        this.childComponent = c;
        if (!this.deactivated) {
            if (this.getViewport() == null) {
                this.setViewport(new JViewport());
            }
            this.getViewport().setView(c);
        } else {
            this.view = new JViewport();
            this.view.setView(c);
            this.doAdd(c);
        }
        return c;
    }

    public void add(Component c, Object layoutmodifier) {
        this.add(c);
    }

    public void setViewportView(Component component) {
        this.add(component);
    }

    public int getHorizontalScrollBarPolicy() {
        return this.horizontalPolicy;
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.horizontalPolicy = policy;
        this.calculateBarSize();
    }

    public int getVerticalScrollBarPolicy() {
        return this.verticalPolicy;
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.verticalPolicy = policy;
        this.calculateBarSize();
    }

    public void setHorizontalScrollBar(JScrollBar bar) {
        this.hbar = bar;
        this.layoutScrollPane();
        this.calculateBarSize();
    }

    public void setVerticalScrollBar(JScrollBar bar) {
        this.vbar = bar;
        this.layoutScrollPane();
        this.calculateBarSize();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hbar;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vbar;
    }

    public Component[] getComponents() {
        return new Component[]{this.childComponent};
    }

    public void setCorner(String key, Component corner) {
        if (key.equals(UPPER_LEFT_CORNER) || key.equals(UPPER_LEADING_CORNER)) {
            this.northPanel.add(corner, "West");
        }
        if (key.equals(UPPER_RIGHT_CORNER) || key.equals(UPPER_TRAILING_CORNER)) {
            this.northPanel.add(corner, "East");
        }
    }

    public void setColumnHeaderView(Component view) {
        this.columnView = view;
        this.northPanel.add(view, "Center");
    }

    public void setRowHeaderView(Component view) {
        this.rowView = view;
        this.westPanel.add(view, "Center");
    }

    public void setSwingWTParent(Container parent) throws Exception {
        super.setSwingWTParent(parent);
        this.handleBarVisibility();
        if (!this.deactivated) {
            SwingUtilities.invokeIn(new Runnable(){

                public void run() {
                    JScrollPane.this.calculateBarSize();
                    JScrollPane.this.adjustmentValueChanged(null);
                }
            }, 500);
        }
    }

    private Dimension calcChildSize() {
        if (this.childComponent == null) {
            this.childComponent = this.getViewport().getComponent(0);
        }
        Dimension childSize = this.childComponent instanceof Scrollable ? ((Scrollable)((Object)this.childComponent)).getPreferredScrollableViewportSize() : this.childComponent.getSize();
        return childSize;
    }

    protected void checkIfComponentCanHandleItself(Component c) {
        this.deactivated = !(c instanceof JPanel) && !(c instanceof JLabel);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e != null) {
            if (e.getSource() == this.vbar) {
                this.ypix = e.getValue() * 10;
            } else {
                this.xpix = e.getValue() * 10;
            }
        }
        Dimension d = this.calcChildSize();
        this.childComponent.setBounds(this.xpix * -1, this.ypix * -1, d.width, d.height);
        if (this.childComponent instanceof Container) {
            ((Container)this.childComponent).invalidate();
        } else {
            this.childComponent.repaint();
        }
        this.view.fireStateChanged();
    }
}

