/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.text;

import swingwt.awt.event.KeyAdapter;
import swingwt.awt.event.KeyEvent;
import swingwtx.swing.event.DocumentEvent;
import swingwtx.swing.event.DocumentListener;
import swingwtx.swing.text.BadLocationException;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.JTextComponent;
import swingwtx.swing.text.View;

public class PlainView
extends View {
    protected JTextComponent comp = null;
    private boolean componentJustChanged = false;
    private boolean noUpdateNextViewChange = false;

    public PlainView(Document doc, JTextComponent component) {
        super(doc);
        this.comp = component;
        this.comp.addKeyListener(new KeyAdapter(){

            public void KeyTyped(KeyEvent e) {
                PlainView.this.updateModelFromComponent(PlainView.this.comp.getText());
            }
        });
        doc.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                PlainView.this.updateComponentFromModel();
            }

            public void removeUpdate(DocumentEvent e) {
                PlainView.this.updateComponentFromModel();
            }

            public void changedUpdate(DocumentEvent e) {
                PlainView.this.updateComponentFromModel();
            }
        });
    }

    public void updateModelFromComponent(String newText) {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc.insertString(0, newText, null);
            this.componentJustChanged = true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void updateComponentFromModel() {
        if (this.componentJustChanged) {
            this.componentJustChanged = false;
            return;
        }
        try {
            this.comp.setText(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
        this.updateComponentFromModel();
    }
}

