/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.undo;

import swingwtx.swing.undo.CannotRedoException;
import swingwtx.swing.undo.CannotUndoException;
import swingwtx.swing.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit {
    private boolean alive = true;
    private boolean completed = true;
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.completed = false;
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.completed = true;
    }

    public void die() {
        this.alive = false;
    }

    public boolean canUndo() {
        return this.completed && this.alive;
    }

    public boolean canRedo() {
        return !this.completed && this.alive;
    }

    public String getUndoPresentationName() {
        return UndoName;
    }

    public String getRedoPresentationName() {
        return RedoName;
    }

    public boolean addEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public String getPresentationName() {
        return "";
    }
}

