/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.ButtonGroup;
import org.eclipse.draw2d.ButtonStateTransitionListener;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.swt.widgets.Display;

public class ButtonModel {
    public static final String ENABLED_PROPERTY = "enabled";
    public static final String PRESSED_PROPERTY = "pressed";
    public static final String SELECTED_PROPERTY = "selected";
    public static final String ROLLOVER_ENABLED_PROPERTY = "rollover enabled";
    public static final String MOUSEOVER_PROPERTY = "mouseover";
    public static final String ARMED_PROPERTY = "armed";
    protected static final int ARMED_FLAG = 1;
    protected static final int PRESSED_FLAG = 2;
    protected static final int MOUSEOVER_FLAG = 4;
    protected static final int SELECTED_FLAG = 8;
    protected static final int ENABLED_FLAG = 16;
    protected static final int ROLLOVER_ENABLED_FLAG = 32;
    protected static final int MAX_FLAG = 32;
    private int state = 16;
    private Object data;
    public static final int DEFAULT_FIRING_BEHAVIOR = 0;
    public static final int REPEAT_FIRING_BEHAVIOR = 1;
    protected String actionName;
    protected ButtonGroup group = null;
    private EventListenerList listeners = new EventListenerList();
    protected ButtonStateTransitionListener firingBehavior;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ButtonModel() {
        this.installFiringBehavior();
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.addListener(clazz, listener);
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.addListener(clazz, listener);
    }

    public void addStateTransitionListener(ButtonStateTransitionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.addListener(clazz, listener);
    }

    protected void fireActionPerformed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        ActionEvent action = new ActionEvent(this);
        while (iter.hasNext()) {
            ((ActionListener)iter.next()).actionPerformed(action);
        }
    }

    protected void fireCanceled() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((ButtonStateTransitionListener)iter.next()).canceled();
        }
    }

    protected void firePressed() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((ButtonStateTransitionListener)iter.next()).pressed();
        }
    }

    protected void fireReleased() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((ButtonStateTransitionListener)iter.next()).released();
        }
    }

    protected void fireResume() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((ButtonStateTransitionListener)iter.next()).resume();
        }
    }

    protected void fireStateChanged(String property) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        ChangeEvent change = new ChangeEvent(this, property);
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).handleStateChanged(change);
        }
    }

    protected void fireSuspend() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Iterator iter = this.listeners.getListeners(clazz);
        while (iter.hasNext()) {
            ((ButtonStateTransitionListener)iter.next()).suspend();
        }
    }

    boolean getFlag(int which) {
        return (this.state & which) != 0;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    public Object getUserData() {
        return this.data;
    }

    protected void installFiringBehavior() {
        this.setFiringBehavior(0);
    }

    public boolean isArmed() {
        return (this.state & 1) != 0;
    }

    public boolean isEnabled() {
        return (this.state & 0x10) != 0;
    }

    public boolean isMouseOver() {
        return (this.state & 4) != 0;
    }

    public boolean isPressed() {
        return (this.state & 2) != 0;
    }

    public boolean isSelected() {
        if (this.group == null) {
            return (this.state & 8) != 0;
        }
        return this.group.isSelected(this);
    }

    public void removeActionListener(ActionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.draw2d.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.removeListener(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.draw2d.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.removeListener(clazz, listener);
    }

    public void removeStateTransitionListener(ButtonStateTransitionListener listener) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.draw2d.ButtonStateTransitionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners.removeListener(clazz, listener);
    }

    public void setArmed(boolean value) {
        if (this.isArmed() == value) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.setFlag(1, value);
        this.fireStateChanged(ARMED_PROPERTY);
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        if (!value) {
            this.setMouseOver(value);
            this.setArmed(value);
            this.setPressed(value);
        }
        this.setFlag(16, value);
        this.fireStateChanged(ENABLED_PROPERTY);
    }

    public void setFiringBehavior(int type) {
        if (this.firingBehavior != null) {
            this.removeStateTransitionListener(this.firingBehavior);
        }
        switch (type) {
            case 1: {
                this.firingBehavior = new RepeatFiringBehavior();
                break;
            }
            default: {
                this.firingBehavior = new DefaultFiringBehavior();
            }
        }
        this.addStateTransitionListener(this.firingBehavior);
    }

    void setFlag(int flag, boolean value) {
        this.state = value ? (this.state |= flag) : (this.state &= ~flag);
    }

    public void setGroup(ButtonGroup bg) {
        if (this.group == bg) {
            return;
        }
        if (this.group != null) {
            this.group.remove(this);
        }
        this.group = bg;
        if (this.group != null) {
            this.group.add(this);
        }
    }

    public void setMouseOver(boolean value) {
        if (this.isMouseOver() == value) {
            return;
        }
        if (this.isPressed()) {
            if (value) {
                this.fireResume();
            } else {
                this.fireSuspend();
            }
        }
        this.setFlag(4, value);
        this.fireStateChanged(MOUSEOVER_PROPERTY);
    }

    public void setPressed(boolean value) {
        if (this.isPressed() == value) {
            return;
        }
        this.setFlag(2, value);
        if (value) {
            this.firePressed();
        } else if (this.isArmed()) {
            this.fireReleased();
        } else {
            this.fireCanceled();
        }
        this.fireStateChanged(PRESSED_PROPERTY);
    }

    public void setSelected(boolean value) {
        if (this.group == null) {
            if (this.isSelected() == value) {
                return;
            }
        } else {
            this.group.setSelected(this, value);
            if (this.getFlag(8) == this.isSelected()) {
                return;
            }
        }
        this.setFlag(8, value);
        this.fireStateChanged(SELECTED_PROPERTY);
    }

    public void setUserData(Object data) {
        this.data = data;
    }

    class DefaultFiringBehavior
    extends ButtonStateTransitionListener {
        DefaultFiringBehavior() {
        }

        public void released() {
            ButtonModel.this.fireActionPerformed();
        }
    }

    class RepeatFiringBehavior
    extends ButtonStateTransitionListener {
        protected static final int INITIAL_DELAY = 250;
        protected static final int STEP_DELAY = 40;
        protected int stepDelay = 250;
        protected int initialDelay = 40;
        protected Timer timer;

        RepeatFiringBehavior() {
        }

        public void pressed() {
            ButtonModel.this.fireActionPerformed();
            if (!ButtonModel.this.isEnabled()) {
                return;
            }
            this.timer = new Timer();
            Task runAction = new Task(this.timer);
            this.timer.scheduleAtFixedRate((TimerTask)runAction, 250L, 40L);
        }

        public void canceled() {
            this.suspend();
        }

        public void released() {
            this.suspend();
        }

        public void resume() {
            this.timer = new Timer();
            Task runAction = new Task(this.timer);
            this.timer.scheduleAtFixedRate((TimerTask)runAction, 40L, 40L);
        }

        public void suspend() {
            if (this.timer == null) {
                return;
            }
            this.timer.cancel();
            this.timer = null;
        }
    }

    class Task
    extends TimerTask {
        private Timer timer;

        public Task(Timer timer) {
            this.timer = timer;
        }

        public void run() {
            Display.getDefault().syncExec(new Runnable(this){
                final /* synthetic */ Task this$1;
                {
                    this.this$1 = task;
                }

                public void run() {
                    if (!Task.access$1(this.this$1).isEnabled()) {
                        Task.access$0(this.this$1).cancel();
                    }
                    Task.access$1(this.this$1).fireActionPerformed();
                }
            });
        }

        static /* synthetic */ Timer access$0(Task task) {
            return task.timer;
        }

        static /* synthetic */ ButtonModel access$1(Task task) {
            return task.ButtonModel.this;
        }
    }
}

