/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ChopboxAnchor
extends AbstractConnectionAnchor {
    protected ChopboxAnchor() {
    }

    public ChopboxAnchor(IFigure owner) {
        super(owner);
    }

    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    protected Rectangle getBox() {
        return this.getOwner().getBounds();
    }

    public Point getReferencePoint() {
        if (this.getOwner() == null) {
            return null;
        }
        Point ref = this.getBox().getCenter();
        this.getOwner().translateToAbsolute(ref);
        return ref;
    }
}

