/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.draw2d.internal.graph.RankSorter;

public class CompoundRankSorter
extends RankSorter {
    boolean init;
    RowKey key = new RowKey();
    Map map = new HashMap();

    void addRowEntry(Subgraph s, int row) {
        this.key.s = s;
        this.key.rank = row;
        if (!this.map.containsKey(this.key)) {
            this.map.put(new RowKey(s, row), new RowEntry());
        }
    }

    protected void assignIncomingSortValues() {
        super.assignIncomingSortValues();
        this.pullTogetherSubgraphs();
    }

    protected void assignOutgoingSortValues() {
        super.assignOutgoingSortValues();
        this.pullTogetherSubgraphs();
    }

    private void pullTogetherSubgraphs() {
    }

    double evaluateNodeOutgoing() {
        double result = super.evaluateNodeOutgoing();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank + 1, result, this.progress);
        }
        return result;
    }

    double evaluateNodeIncoming() {
        double result = super.evaluateNodeIncoming();
        if (this.progress > 0.2) {
            double connectivity;
            Subgraph s = this.node.getParent();
            result = connectivity = this.mergeConnectivity(s, this.node.rank - 1, result, this.progress);
        }
        return result;
    }

    double mergeConnectivity(Subgraph s, int row, double result, double scaleFactor) {
        while (s != null && this.getRowEntry(s, row) == null) {
            s = s.getParent();
        }
        if (s != null) {
            RowEntry entry = this.getRowEntry(s, row);
            double connectivity = entry.contribution / (double)entry.count;
            result = connectivity * 0.3 + 0.7 * result;
            s = s.getParent();
        }
        return result;
    }

    RowEntry getRowEntry(Subgraph s, int row) {
        this.key.s = s;
        this.key.rank = row;
        return (RowEntry)this.map.get(this.key);
    }

    public void init(DirectedGraph g) {
        super.init(g);
        this.init = true;
        int row = 0;
        while (row < g.ranks.size()) {
            Rank rank = g.ranks.getRank(row);
            int j = 0;
            while (j < rank.count()) {
                Node n = rank.getNode(j);
                Subgraph s = n.getParent();
                while (s != null) {
                    this.addRowEntry(s, row);
                    s = s.getParent();
                }
                ++j;
            }
            ++row;
        }
    }

    protected void postSort() {
        super.postSort();
        this.updateRank(this.rank);
    }

    void updateRank(Rank rank) {
        Subgraph s;
        Node n;
        int j = 0;
        while (j < rank.count()) {
            n = rank.getNode(j);
            s = n.getParent();
            while (s != null) {
                this.getRowEntry(s, this.currentRow).reset();
                s = s.getParent();
            }
            ++j;
        }
        j = 0;
        while (j < rank.count()) {
            n = rank.getNode(j);
            s = n.getParent();
            while (s != null) {
                RowEntry entry = this.getRowEntry(s, this.currentRow);
                ++entry.count;
                entry.contribution += (double)n.index;
                s = s.getParent();
            }
            ++j;
        }
    }

    static class RowEntry {
        double contribution;
        int count;

        RowEntry() {
        }

        void reset() {
            this.count = 0;
            this.contribution = 0.0;
        }
    }

    static class RowKey {
        int rank;
        Subgraph s;

        RowKey() {
        }

        RowKey(Subgraph s, int rank) {
            this.s = s;
            this.rank = rank;
        }

        public boolean equals(Object obj) {
            RowKey rp = (RowKey)obj;
            return rp.s == this.s && rp.rank == this.rank;
        }

        public int hashCode() {
            return this.s.hashCode() ^ this.rank * 31;
        }
    }
}

