/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.VirtualNode;
import org.eclipse.draw2d.internal.graph.InitialRankSolver;
import org.eclipse.draw2d.internal.graph.NodePair;
import org.eclipse.draw2d.internal.graph.RankAssigmentSolver;
import org.eclipse.draw2d.internal.graph.SpanningTreeVisitor;
import org.eclipse.draw2d.internal.graph.TightSpanningTreeSolver;

public class HorizontalPlacement
extends SpanningTreeVisitor {
    private List allClusters;
    private Map clusterMap = new HashMap();
    private Map clusterSetCache = new HashMap();
    public DirectedGraph graph;
    Map map = new HashMap();
    public DirectedGraph prime;

    void addEdges(Node n, Node nPrime) {
        if (n instanceof VirtualNode) {
            this.addEdges((VirtualNode)n, nPrime);
            return;
        }
        int i = 0;
        while (i < n.incoming.size()) {
            Edge eu;
            Node ne;
            Node nPrimeSource;
            Node nSource;
            Edge e = n.incoming.getEdge(i);
            if (e.vNodes != null) {
                nSource = e.vNodes.getNode(e.vNodes.size() - 1);
                nPrimeSource = this.get(nSource);
                ne = new Node(new NodePair(n, nSource));
                ne.y = (n.y + n.height + nSource.y) / 2;
                this.prime.nodes.add(ne);
                eu = new Edge(ne, nPrimeSource);
                Edge ev = new Edge(ne, nPrime);
                eu.delta = e.getTargetOffset();
                ev.delta = 0;
                eu.weight = ev.weight = e.weight * 2;
                this.prime.edges.add(eu);
                this.prime.edges.add(ev);
            } else {
                nSource = e.source;
                nPrimeSource = this.get(e.source);
                ne = new Node(new NodePair(n, nSource));
                ne.y = (n.y + n.height + nSource.y) / 2;
                this.prime.nodes.add(ne);
                eu = new Edge(ne, nPrimeSource);
                int dw = e.getSourceOffset() - e.getTargetOffset();
                eu.delta = 0;
                eu.weight = e.weight;
                Edge ev = new Edge(ne, nPrime);
                ev.delta = 0;
                if (dw < 0) {
                    eu.delta = -dw;
                } else {
                    ev.delta = dw;
                }
                ev.weight = e.weight;
                this.prime.edges.add(eu);
                this.prime.edges.add(ev);
            }
            ++i;
        }
    }

    void addEdges(VirtualNode vn, Node nPrime) {
        Node prevPrime = this.get(vn.prev);
        Node vnSource = vn.prev;
        Node ne = new Node(new NodePair(vn, vnSource));
        ne.y = (vn.y + vn.height + vnSource.y) / 2;
        this.prime.nodes.add(ne);
        Edge eu = new Edge(ne, prevPrime);
        eu.delta = 0;
        eu.weight = vn.omega();
        Edge ev = new Edge(ne, nPrime, 0, eu.weight);
        if (!(vn.prev instanceof VirtualNode)) {
            ev.delta = ((Edge)vn.data).getSourceOffset();
        }
        this.prime.edges.add(eu);
        this.prime.edges.add(ev);
    }

    void applyGPrime() {
        int n = 0;
        while (n < this.prime.nodes.size()) {
            Node node = this.prime.nodes.getNode(n);
            if (node.data instanceof Node) {
                ((Node)node.data).x = node.rank;
            }
            ++n;
        }
    }

    private void balanceClusters() {
        boolean condition;
        this.findAllClusters();
        do {
            condition = false;
            int i = 0;
            while (i < this.allClusters.size()) {
                NodeCluster c = (NodeCluster)this.allClusters.get(i);
                c.updateValues();
                if (c.pull < 0 && c.leftFreedom > 0) {
                    c.adjustRank(Math.max(c.pull, -c.leftFreedom));
                    condition = true;
                    this.allClusters.remove(c);
                    this.allClusters.add(0, c);
                    i = 0;
                    ++c.modified;
                } else if (c.pull > 0 && c.rightFreedom > 0) {
                    c.adjustRank(Math.min(c.pull, c.rightFreedom));
                    condition = true;
                    this.allClusters.remove(c);
                    this.allClusters.add(0, c);
                    i = 0;
                    ++c.modified;
                }
                ++i;
            }
            if (condition) continue;
            condition = this.balanceClusterSets();
        } while (condition);
    }

    private boolean balanceClusterSets() {
        int i = 0;
        while (i < this.allClusters.size()) {
            Edge e;
            Iterator iter;
            boolean condition;
            NodeCluster cluster;
            HashSet<NodeCluster> set;
            NodeCluster seed = (NodeCluster)this.allClusters.get(i);
            if (seed.pull < 0 && seed.leftFreedom == 0) {
                set = new HashSet<NodeCluster>();
                set.add(seed);
                cluster = seed;
                do {
                    condition = false;
                    iter = cluster.incoming.iterator();
                    while (iter.hasNext()) {
                        e = (Edge)iter.next();
                        if (e.getSlack() != 0) continue;
                        condition = true;
                        set.add((NodeCluster)this.clusterMap.get(e.source));
                    }
                    cluster = this.getCachedClusterSet(set);
                    cluster.updateValues();
                } while (cluster.leftFreedom == 0 && cluster.pull < 0 && condition);
                if (cluster.pull < 0) {
                    cluster.adjustRank(Math.max(cluster.pull, -cluster.leftFreedom));
                    this.allClusters.remove(seed);
                    this.allClusters.add(0, seed);
                    return true;
                }
            } else if (seed.pull > 0 && seed.rightFreedom > 0) {
                set = new HashSet();
                set.add(seed);
                cluster = seed;
                do {
                    condition = false;
                    iter = cluster.outgoing.iterator();
                    while (iter.hasNext()) {
                        e = (Edge)iter.next();
                        if (e.getSlack() != 0) continue;
                        condition = true;
                        set.add((NodeCluster)this.clusterMap.get(e.target));
                    }
                    cluster = this.getCachedClusterSet(set);
                    cluster.updateValues();
                } while (cluster.rightFreedom == 0 && cluster.pull > 0 && condition);
                if (cluster.pull > 0) {
                    cluster.adjustRank(Math.min(cluster.pull, cluster.rightFreedom));
                    this.allClusters.remove(seed);
                    this.allClusters.add(0, seed);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private NodeCluster getCachedClusterSet(Set set) {
        NodeCluster cluster = (NodeCluster)this.clusterSetCache.get(set);
        if (cluster != null) {
            return cluster;
        }
        cluster = new NodeCluster();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            cluster.union((NodeCluster)iter.next());
        }
        cluster.updateValues();
        this.clusterSetCache.put(set, cluster);
        return cluster;
    }

    void buildGPrime() {
        RankList ranks = this.graph.ranks;
        this.buildRankSeparators(ranks);
        int r = 1;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            int i = 0;
            while (i < rank.count()) {
                Node n = rank.getNode(i);
                Node nPrime = this.get(n);
                this.addEdges(n, nPrime);
                ++i;
            }
            ++r;
        }
    }

    void buildRankSeparators(RankList ranks) {
        int r = 0;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            Node prevNPrime = null;
            int i = 0;
            while (i < rank.count()) {
                Node n = rank.getNode(i);
                Node nPrime = new Node(n);
                if (prevNPrime != null) {
                    Edge e = new Edge(prevNPrime, nPrime);
                    e.weight = 0;
                    this.prime.edges.add(e);
                    this.rowSeparation(e);
                }
                prevNPrime = nPrime;
                this.prime.nodes.add(nPrime);
                this.map(n, nPrime);
                ++i;
            }
            ++r;
        }
    }

    Node get(Node key) {
        return (Node)this.map.get(key);
    }

    void growCluster(Node root, NodeCluster cluster, List allClusters) {
        cluster.add(root);
        this.clusterMap.put(root, cluster);
        EdgeList treeChildren = this.getSpanningTreeChildren(root);
        int i = 0;
        while (i < treeChildren.size()) {
            Edge e = treeChildren.getEdge(i);
            if (e.cut != 0) {
                this.growCluster(this.getTreeTail(e), cluster, allClusters);
            } else {
                NodeCluster newCluster = new NodeCluster();
                allClusters.add(newCluster);
                this.growCluster(this.getTreeTail(e), newCluster, allClusters);
            }
            ++i;
        }
    }

    private void findAllClusters() {
        Node root = this.prime.nodes.getNode(0);
        NodeCluster cluster = new NodeCluster();
        this.allClusters = new ArrayList();
        this.allClusters.add(cluster);
        this.growCluster(root, cluster, this.allClusters);
        int i = 0;
        while (i < this.allClusters.size()) {
            NodeCluster c = (NodeCluster)this.allClusters.get(i);
            c.build();
            ++i;
        }
    }

    void map(Node key, Node value) {
        this.map.put(key, value);
    }

    void rowSeparation(Edge e) {
        Node source = (Node)e.source.data;
        e.delta = source.width + 15;
    }

    public void visit(DirectedGraph g) {
        this.graph = g;
        g.gPrime = this.prime = new DirectedGraph();
        this.buildGPrime();
        new InitialRankSolver().visit(this.prime);
        new TightSpanningTreeSolver().visit(this.prime);
        RankAssigmentSolver solver = new RankAssigmentSolver();
        solver.visit(this.prime);
        this.balanceClusters();
        this.prime.nodes.normalizeRanks();
        this.applyGPrime();
    }

    class NodeCluster
    extends NodeList {
        final int hash = new Object().hashCode();
        Set incoming = new HashSet();
        int leftFreedom;
        int modified;
        Set outgoing = new HashSet();
        int pull;
        int rightFreedom;

        NodeCluster() {
        }

        void build() {
            this.incoming.clear();
            this.outgoing.clear();
            int i = 0;
            while (i < this.size()) {
                Edge e;
                Node node = this.getNode(i);
                int j = 0;
                while (j < node.incoming.size()) {
                    e = node.incoming.getEdge(j);
                    if (!this.contains(e.source)) {
                        this.incoming.add(e);
                    }
                    ++j;
                }
                j = 0;
                while (j < node.outgoing.size()) {
                    e = node.outgoing.getEdge(j);
                    if (!this.contains(e.target)) {
                        this.outgoing.add(e);
                    }
                    ++j;
                }
                ++i;
            }
        }

        public boolean equals(Object o) {
            return o == this;
        }

        int getPull() {
            return this.pull;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            this.updateValues();
            StringBuffer buffer = new StringBuffer("-----Cluster-------");
            buffer.append("\n pull:" + this.pull);
            buffer.append("\n left:" + this.leftFreedom);
            buffer.append("\n right:" + this.rightFreedom);
            buffer.append("\n modified:" + this.modified);
            int i = 0;
            while (i < this.size()) {
                Node node = (Node)this.get(i);
                buffer.append("\n\t" + node);
                ++i;
            }
            return buffer.toString();
        }

        void union(NodeCluster other) {
            this.addAll(other);
            this.incoming.addAll(other.incoming);
            this.outgoing.addAll(other.outgoing);
            Iterator iter = this.incoming.iterator();
            while (iter.hasNext()) {
                Object edge = iter.next();
                if (!this.outgoing.remove(edge)) continue;
                iter.remove();
            }
        }

        void updateValues() {
            Edge e;
            this.pull = 0;
            int pullCount = 0;
            int unweighted = 0;
            this.rightFreedom = Integer.MAX_VALUE;
            this.leftFreedom = Integer.MAX_VALUE;
            Iterator iter = this.incoming.iterator();
            while (iter.hasNext()) {
                e = (Edge)iter.next();
                this.pull -= e.getSlack() * e.weight;
                unweighted -= e.getSlack();
                pullCount += e.weight;
                this.leftFreedom = Math.min(e.getSlack(), this.leftFreedom);
            }
            iter = this.outgoing.iterator();
            while (iter.hasNext()) {
                e = (Edge)iter.next();
                this.pull += e.getSlack() * e.weight;
                unweighted += e.getSlack();
                pullCount += e.weight;
                this.rightFreedom = Math.min(e.getSlack(), this.rightFreedom);
            }
            this.pull = pullCount != 0 ? (this.pull /= pullCount) : (this.outgoing.size() + this.incoming.size() == 0 ? 0 : unweighted / (this.outgoing.size() + this.incoming.size()));
        }
    }
}

