/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowBox;

public class LineBox
extends CompositeBox {
    private int ascent = 0;

    public void commit() {
        int baseline = this.getBaseline();
        int xLocation = this.x;
        int i = 0;
        while (i < this.fragments.size()) {
            FlowBox block = (FlowBox)this.fragments.get(i);
            block.x = xLocation;
            xLocation += block.width;
            block.makeBaseline(baseline);
            ++i;
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getAvailableWidth() {
        if (this.recommendedWidth < 0) {
            return Integer.MAX_VALUE;
        }
        return this.recommendedWidth - this.width;
    }

    public int getBaseline() {
        return this.y + this.getAscent();
    }

    public void makeBaseline(int value) {
        super.makeBaseline(value);
        this.commit();
    }

    protected void resetInfo() {
        super.resetInfo();
        this.ascent = 0;
    }

    protected void unionInfo(FlowBox blockInfo) {
        int descent = this.height - this.ascent;
        this.ascent = Math.max(this.ascent, blockInfo.getAscent());
        this.height = this.ascent + Math.max(descent, blockInfo.getDescent());
        this.width += blockInfo.width;
    }
}

