/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ContentDescription
implements IContentDescription {
    private String charset;
    private IContentType contentType;
    private boolean immutable;
    private int mark;
    private Map properties;

    ContentDescription() {
    }

    private void assertMutable() {
        if (this.immutable) {
            throw new IllegalStateException("Content description is immutable");
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public int getMark() {
        return this.mark;
    }

    public Object getProperty(QualifiedName key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void markAsImmutable() {
        this.assertMutable();
        this.immutable = true;
    }

    public void setCharset(String charset) {
        this.assertMutable();
        this.charset = charset;
    }

    public void setContentType(IContentType contentType) {
        this.assertMutable();
        this.contentType = contentType;
    }

    public void setMark(int mark) {
        this.assertMutable();
        this.mark = mark;
    }

    public void setProperty(QualifiedName key, Object value) {
        this.assertMutable();
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }
}

