/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.IRegistryElement;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.osgi.framework.Bundle;

public class BundleModel
extends RegistryModelObject
implements IRegistryElement {
    private static final String NO_EXTENSION_MUNGING = "eclipse.noExtensionMunging";
    private static final String DEFAULT_BUNDLE_NAME = "plugin";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static String[] NL_JAR_VARIANTS = BundleModel.buildNLVariants(InternalPlatform.getDefault().getNL());
    private String hostId;
    private IExtensionPoint[] extensionPoints;
    private IExtension[] extensions;
    private transient Object locale;
    private transient boolean bundleNotFound;
    private transient ResourceBundle resourceBundle;
    private long bundleId;
    private static Map renamedUIextensionPoints;
    private String schemaVersion;

    public String getUniqueIdentifier() {
        return this.getName();
    }

    public void setUniqueIdentifier(String value) {
        this.setName(value);
    }

    public void setExtensions(IExtension[] value) {
        this.assertIsWriteable();
        this.extensions = value;
        this.fixRenamedExtensionPoints();
    }

    public IExtension getExtension(String id) {
        if (id == null) {
            return null;
        }
        IExtension[] list = this.getExtensions();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (id.equals(list[i].getUniqueIdentifier())) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public IExtension[] getExtensions() {
        return this.extensions == null ? new IExtension[]{} : this.extensions;
    }

    public void markReadOnly() {
        int i;
        super.markReadOnly();
        if (this.extensionPoints != null) {
            i = 0;
            while (i < this.extensionPoints.length) {
                ((ExtensionPoint)this.extensionPoints[i]).markReadOnly();
                ++i;
            }
        }
        if (this.extensions != null) {
            i = 0;
            while (i < this.extensions.length) {
                ((Extension)this.extensions[i]).markReadOnly();
                ++i;
            }
        }
    }

    public void setExtensionPoints(IExtensionPoint[] value) {
        this.assertIsWriteable();
        this.extensionPoints = value;
    }

    public IExtensionPoint getExtensionPoint(String xpt) {
        if (xpt == null) {
            return null;
        }
        IExtensionPoint[] list = this.getExtensionPoints();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (xpt.equals(list[i].getSimpleIdentifier())) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints == null ? new IExtensionPoint[]{} : this.extensionPoints;
    }

    public ResourceBundle getResourceBundle() throws MissingResourceException {
        return this.getResourceBundle(Locale.getDefault());
    }

    private static String[] buildNLVariants(String nl) {
        int lastSeparator;
        ArrayList<String> result = new ArrayList<String>();
        while ((lastSeparator = nl.lastIndexOf(95)) != -1) {
            result.add(nl);
            if (lastSeparator == -1) continue;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(nl);
        return result.toArray(new String[result.size()]);
    }

    private URL findProperties(Bundle bundle, String path) {
        String[] nlVariants = NL_JAR_VARIANTS;
        URL result = null;
        int i = 0;
        while (i < nlVariants.length) {
            String filePath = path.concat("_" + nlVariants[i] + ".properties");
            result = this.findInPlugin(bundle, filePath);
            if (result != null) {
                return result;
            }
            result = this.findInFragments(bundle, filePath);
            if (result != null) {
                return result;
            }
            ++i;
        }
        result = this.findInPlugin(bundle, String.valueOf(path) + ".properties");
        if (result != null) {
            return result;
        }
        return this.findInFragments(bundle, String.valueOf(path) + ".properties");
    }

    private URL findInPlugin(Bundle bundle, String filePath) {
        return bundle.getEntry(filePath);
    }

    private URL findInFragments(Bundle bundle, String filePath) {
        Bundle[] fragments = InternalPlatform.getDefault().getFragments(bundle);
        URL fileURL = null;
        int i = 0;
        while (fragments != null && i < fragments.length && fileURL == null) {
            fileURL = fragments[i].getEntry(filePath);
            ++i;
        }
        return fileURL;
    }

    public ResourceBundle getResourceBundle(Locale targetLocale) throws MissingResourceException {
        if (this.resourceBundle != null && targetLocale.equals(this.locale)) {
            return this.resourceBundle;
        }
        if (this.bundleNotFound) {
            throw new MissingResourceException(Policy.bind("plugin.bundleNotFound", this.getName(), "plugin_" + targetLocale), "plugin_" + targetLocale, "");
        }
        Bundle bundle = InternalPlatform.getDefault().getBundle(this.getName());
        URL resourceURL = null;
        resourceURL = this.findProperties(bundle, DEFAULT_BUNDLE_NAME);
        if (resourceURL == null) {
            this.bundleNotFound = true;
            this.resourceBundle = null;
            throw new MissingResourceException(Policy.bind("plugin.bundleNotFound", this.getName(), "plugin_" + targetLocale), "plugin_" + targetLocale, "");
        }
        InputStream resourceStream = null;
        try {
            resourceStream = resourceURL.openStream();
            this.resourceBundle = new PropertyResourceBundle(resourceStream);
        }
        catch (IOException iOException) {
            if (resourceStream != null) {
                try {
                    resourceStream.close();
                }
                catch (IOException iOException2) {}
            }
            this.bundleNotFound = true;
            throw new MissingResourceException(Policy.bind("plugin.bundleNotFound", this.getName(), "plugin_" + targetLocale), "plugin_" + targetLocale, "");
        }
        this.locale = targetLocale;
        return this.resourceBundle;
    }

    public String getResourceString(String value) {
        return this.getResourceString(value, null);
    }

    public String getResourceString(String value, ResourceBundle bundle) {
        String dflt;
        String s = value.trim();
        if (!s.startsWith(KEY_PREFIX)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX)) {
            return s.substring(1);
        }
        int ix = s.indexOf(" ");
        String key = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (bundle == null) {
            try {
                bundle = this.getResourceBundle();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (bundle == null) {
            return dflt;
        }
        try {
            return bundle.getString(key.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return KEY_PREFIX + dflt;
        }
    }

    public void setHostIdentifier(String value) {
        this.hostId = value;
    }

    public String getHostIdentifier() {
        return this.hostId;
    }

    public boolean isFragment() {
        return this.hostId != null;
    }

    public String toString() {
        return "BundleModel: " + this.getName();
    }

    private void fixRenamedExtensionPoints() {
        if (this.extensions == null || this.schemaVersion != null && this.schemaVersion.equals("3.0") || System.getProperties().get(NO_EXTENSION_MUNGING) != null) {
            return;
        }
        if (renamedUIextensionPoints == null) {
            HashMap<String, String> t = new HashMap<String, String>(13);
            t.put("org.eclipse.ui.markerImageProvider", "org.eclipse.ui.ide.markerImageProvider");
            t.put("org.eclipse.ui.markerHelp", "org.eclipse.ui.ide.markerHelp");
            t.put("org.eclipse.ui.markerImageProviders", "org.eclipse.ui.ide.markerImageProviders");
            t.put("org.eclipse.ui.markerResolution", "org.eclipse.ui.ide.markerResolution");
            t.put("org.eclipse.ui.projectNatureImages", "org.eclipse.ui.ide.projectNatureImages");
            t.put("org.eclipse.ui.resourceFilters", "org.eclipse.ui.ide.resourceFilters");
            t.put("org.eclipse.ui.markerUpdaters", "org.eclipse.ui.editors.markerUpdaters");
            t.put("org.eclipse.ui.documentProviders", "org.eclipse.ui.editors.documentProviders");
            t.put("org.eclipse.ui.workbench.texteditor.markerAnnotationSpecification", "org.eclipse.ui.editors.markerAnnotationSpecification");
            t.put("org.eclipse.help.browser", "org.eclipse.help.base.browser");
            t.put("org.eclipse.help.luceneAnalyzer", "org.eclipse.help.base.luceneAnalyzer");
            t.put("org.eclipse.help.webapp", "org.eclipse.help.base.webapp");
            t.put("org.eclipse.help.support", "org.eclipse.ui.helpSupport");
            renamedUIextensionPoints = t;
        }
        int i = 0;
        while (i < this.extensions.length) {
            Extension extension = (Extension)this.extensions[i];
            String oldPointId = extension.getExtensionPointIdentifier();
            String newPointId = (String)renamedUIextensionPoints.get(oldPointId);
            if (newPointId != null) {
                extension.setExtensionPointIdentifier(newPointId);
            }
            ++i;
        }
    }

    protected void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public long getId() {
        return this.bundleId;
    }

    public void setId(long value) {
        this.bundleId = value;
    }
}

