/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.CRC32;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.IniFileReader;

public final class AboutInfo {
    private static final String INI_FILENAME = "about.ini";
    private static final String PROPERTIES_FILENAME = "about.properties";
    private static final String MAPPINGS_FILENAME = "about.mappings";
    private static final int BYTE_ARRAY_SIZE = 2048;
    private String featureId;
    private String versionId = "";
    private String featurePluginLabel;
    private String providerName;
    private String appName;
    private ImageDescriptor[] windowImages;
    private ImageDescriptor aboutImage;
    private ImageDescriptor featureImage;
    private String aboutText;
    private URL welcomePageURL;
    private String welcomePerspective;
    private String tipsAndTricksHref;
    private URL featureImageURL;
    private Long featureImageCRC;
    private boolean calculatedImageCRC = false;

    AboutInfo(String featureId) {
        this.featureId = featureId;
    }

    public static AboutInfo readFeatureInfo(String featureId, String versionId, String pluginId) {
        Assert.isNotNull((Object)featureId);
        Assert.isNotNull((Object)versionId);
        Assert.isNotNull((Object)pluginId);
        IniFileReader reader = new IniFileReader(featureId, pluginId, INI_FILENAME, PROPERTIES_FILENAME, MAPPINGS_FILENAME);
        IStatus status = reader.load();
        if (!status.isOK()) {
            return null;
        }
        AboutInfo info = new AboutInfo(featureId);
        Hashtable<String, String> runtimeMappings = new Hashtable<String, String>();
        runtimeMappings.put("{featureVersion}", versionId);
        info.versionId = versionId;
        info.featurePluginLabel = reader.getFeaturePluginLabel();
        info.providerName = reader.getProviderName();
        info.appName = reader.getString("appName", true, runtimeMappings);
        info.aboutText = reader.getString("aboutText", true, runtimeMappings);
        info.windowImages = reader.getImages("windowImages");
        if (info.windowImages == null) {
            info.windowImages = reader.getImages("windowImage");
        }
        info.aboutImage = reader.getImage("aboutImage");
        info.featureImage = reader.getImage("featureImage");
        info.featureImageURL = reader.getURL("featureImage");
        info.welcomePageURL = reader.getURL("welcomePage");
        info.welcomePerspective = reader.getString("welcomePerspective", false, runtimeMappings);
        info.tipsAndTricksHref = reader.getString("tipsAndTricksHref", false, runtimeMappings);
        return info;
    }

    public ImageDescriptor getAboutImage() {
        return this.aboutImage;
    }

    public ImageDescriptor getFeatureImage() {
        return this.featureImage;
    }

    public String getFeatureImageName() {
        if (this.featureImageURL != null) {
            Path path = new Path(this.featureImageURL.getPath());
            return path.lastSegment();
        }
        return null;
    }

    public Long getFeatureImageCRC() {
        if (!this.calculatedImageCRC && this.featureImageURL != null) {
            this.featureImageCRC = this.calculateFeatureImageCRC();
            this.calculatedImageCRC = true;
        }
        return this.featureImageCRC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long calculateFeatureImageCRC() {
        Long l;
        ByteArrayOutputStream out;
        block17: {
            if (this.featureImageURL == null) {
                return null;
            }
            InputStream in = null;
            out = null;
            try {
                try {
                    in = this.featureImageURL.openStream();
                    out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[2048];
                    int readResult = 2048;
                    while (true) {
                        if (readResult != 2048) {
                            byte[] contents = out.toByteArray();
                            CRC32 crc = new CRC32();
                            crc.update(contents);
                            l = new Long(crc.getValue());
                            Object var7_9 = null;
                            if (in == null) break block17;
                            break;
                        }
                        readResult = in.read(buffer);
                        if (readResult <= 0) continue;
                        out.write(buffer, 0, readResult);
                    }
                }
                catch (IOException iOException) {
                    Long l2 = null;
                    Object var7_10 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (out == null) return l2;
                    try {
                        out.close();
                        return l2;
                    }
                    catch (IOException iOException3) {}
                    return l2;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (in != null) {
                    try {}
                    catch (IOException iOException) {}
                    in.close();
                }
                if (out == null) throw throwable;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                out.close();
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        if (out == null) return l;
        try {}
        catch (IOException iOException) {}
        out.close();
        return l;
    }

    public String getFeatureLabel() {
        return this.featurePluginLabel;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProductName() {
        return this.featurePluginLabel;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public URL getWelcomePageURL() {
        return this.welcomePageURL;
    }

    public String getWelcomePerspectiveId() {
        return this.welcomePerspective;
    }

    public String getTipsAndTricksHref() {
        return this.tipsAndTricksHref;
    }

    public ImageDescriptor[] getWindowImages() {
        return this.windowImages;
    }
}

