/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AssociatedWindow
extends Window {
    protected static final int TRACK_OUTER_TOP_RHS = 0;
    protected static final int TRACK_INNER_TOP_RHS = 1;
    protected static final int TRACK_OUTER_BOTTOM_RHS = 2;
    protected static final int TRACK_INNER_BOTTOM_RHS = 3;
    protected static final int HORIZONTAL_VISIBLE = 0;
    protected static final int ALWAYS_VISIBLE = 1;
    private Control owner;
    private ControlListener controlListener;
    private int trackStyle;
    private int moveType;
    private Region roundRegion;

    public AssociatedWindow(Shell parent, Control associatedControl, int trackStyle) {
        super(parent);
        this.setShellStyle(8);
        this.owner = associatedControl;
        this.trackStyle = trackStyle;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.associate(newShell);
    }

    protected void moveShell(Shell shellToMove, int moveConstant) {
        this.moveType = moveConstant;
        if (shellToMove.isDisposed()) {
            return;
        }
        Rectangle displayRect = this.owner.getMonitor().getClientArea();
        Point location = this.getLocation(shellToMove);
        Point shellSize = shellToMove.getSize();
        if (this.moveType == 0) {
            if (this.trackStyle == 0 || this.trackStyle == 2) {
                if (location.x + shellSize.x > displayRect.width && location.x < displayRect.width) {
                    location.x = displayRect.width - shellSize.x;
                } else if (location.x >= displayRect.width) {
                    location.x -= shellSize.x;
                }
            }
            shellToMove.setLocation(location);
        } else {
            Rectangle currentRect = shellToMove.getBounds();
            currentRect.x = location.x;
            currentRect.y = location.y;
            shellToMove.setBounds(this.getConstrainedShellBounds(currentRect));
        }
        Region oldRegion = shellToMove.getRegion();
        Region outerRegion = this.getRoundCorners(shellToMove.getClientArea(), shellToMove);
        shellToMove.setRegion(outerRegion);
        if (oldRegion != null) {
            oldRegion.dispose();
        }
    }

    private Point getLocation(Shell shellToMove) {
        switch (this.trackStyle) {
            case 0: {
                return this.getLocationOuterTopRHS(shellToMove);
            }
            case 1: {
                return this.getLocationInnerTopRHS(shellToMove);
            }
            case 2: {
                return this.getLocationOuterBottomRHS(shellToMove);
            }
            case 3: {
                return this.getLocationInnerBottomRHS(shellToMove);
            }
        }
        return this.getLocationOuterTopRHS(shellToMove);
    }

    private Point getLocationOuterTopRHS(Shell shellToMove) {
        Point loc = this.owner.getDisplay().map(this.owner, null, 0, 0);
        Point size = this.owner.getSize();
        return new Point(loc.x + size.x, loc.y);
    }

    private Point getLocationInnerTopRHS(Shell shellToMove) {
        Point loc = this.owner.getDisplay().map(this.owner, null, 0, 0);
        Point ownerSize = this.owner.getSize();
        Point size = shellToMove.getSize();
        return new Point(loc.x + ownerSize.x - size.x, loc.y);
    }

    private Point getLocationOuterBottomRHS(Shell shellToMove) {
        Point loc = this.owner.getDisplay().map(this.owner, null, 0, 0);
        Point ownerSize = this.owner.getSize();
        Point size = shellToMove.getSize();
        return new Point(loc.x + ownerSize.x, loc.y + ownerSize.y - size.y);
    }

    private Point getLocationInnerBottomRHS(Shell shellToMove) {
        Point loc = this.owner.getDisplay().map(this.owner, null, 0, 0);
        Point ownerSize = this.owner.getSize();
        Point size = shellToMove.getSize();
        return new Point(loc.x, loc.y + ownerSize.y - size.y);
    }

    private void associate(final Shell floatingShell) {
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                AssociatedWindow.this.moveShell(floatingShell, AssociatedWindow.this.moveType);
            }

            public void controlResized(ControlEvent e) {
                AssociatedWindow.this.moveShell(floatingShell, AssociatedWindow.this.moveType);
            }
        };
        this.owner.addControlListener(this.controlListener);
        this.getParentShell().addControlListener(this.controlListener);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected void addRoundBorder(final Shell paintShell, final int borderSize) {
        paintShell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (paintShell == null || paintShell.isDisposed()) {
                    return;
                }
                if (2 * borderSize >= paintShell.getBounds().width || 2 * borderSize >= paintShell.getBounds().height) {
                    return;
                }
                Rectangle outerShellSize = paintShell.getClientArea();
                GC gc = event.gc;
                gc.setClipping(this.getBorderRegion(outerShellSize, paintShell));
                gc.setBackground(paintShell.getDisplay().getSystemColor(18));
                gc.fillRoundRectangle(0, 0, outerShellSize.width, outerShellSize.height, 5, 5);
            }

            private Region getBorderRegion(Rectangle outerShellSize, Shell newShell) {
                if (AssociatedWindow.this.roundRegion != null) {
                    return AssociatedWindow.this.roundRegion;
                }
                Rectangle innerShellSize = new Rectangle(borderSize, borderSize, outerShellSize.width - 2 * borderSize, outerShellSize.height - 2 * borderSize);
                AssociatedWindow.this.roundRegion = new Region((Device)AssociatedWindow.this.getShell().getDisplay());
                Region outerRegion = newShell.getRegion();
                boolean tempRegion = false;
                if (outerRegion == null) {
                    outerRegion = AssociatedWindow.this.getRoundCorners(outerShellSize, newShell);
                    tempRegion = true;
                }
                Region innerRegion = AssociatedWindow.this.getRoundCorners(innerShellSize, newShell);
                AssociatedWindow.this.roundRegion.add(outerRegion);
                AssociatedWindow.this.roundRegion.subtract(innerRegion);
                if (tempRegion) {
                    outerRegion.dispose();
                }
                innerRegion.dispose();
                return AssociatedWindow.this.roundRegion;
            }
        });
    }

    private Region getRoundCorners(Rectangle size, Shell roundShell) {
        Region r = new Region((Device)roundShell.getDisplay());
        r.add(new Rectangle(size.x, size.y, size.width, size.height));
        Region cornerRegion = new Region((Device)roundShell.getDisplay());
        this.addTopRightCorner(cornerRegion, size);
        this.addBottomRightCorner(cornerRegion, size);
        this.addTopLeftCorner(cornerRegion, size);
        this.addBottomLeftCorner(cornerRegion, size);
        r.subtract(cornerRegion);
        cornerRegion.dispose();
        return r;
    }

    private void addTopRightCorner(Region cornerRegion, Rectangle shellSize) {
        cornerRegion.add(new Rectangle(shellSize.width - 5 + shellSize.x, 0 + shellSize.y, 5, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 3 + shellSize.x, 1 + shellSize.y, 3, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 2 + shellSize.x, 2 + shellSize.y, 2, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 1 + shellSize.x, 3 + shellSize.y, 1, 2));
    }

    private void addBottomRightCorner(Region cornerRegion, Rectangle shellSize) {
        cornerRegion.add(new Rectangle(shellSize.width - 5 + shellSize.x, shellSize.height - 1 + shellSize.y, 5, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 3 + shellSize.x, shellSize.height - 2 + shellSize.y, 3, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 2 + shellSize.x, shellSize.height - 3 + shellSize.y, 2, 1));
        cornerRegion.add(new Rectangle(shellSize.width - 1 + shellSize.x, shellSize.height - 5 + shellSize.y, 1, 2));
    }

    private void addTopLeftCorner(Region cornerRegion, Rectangle shellSize) {
        cornerRegion.add(new Rectangle(0 + shellSize.x, 0 + shellSize.y, 5, 1));
        cornerRegion.add(new Rectangle(0 + shellSize.x, 1 + shellSize.y, 3, 1));
        cornerRegion.add(new Rectangle(0 + shellSize.x, 2 + shellSize.y, 2, 1));
        cornerRegion.add(new Rectangle(0 + shellSize.x, 3 + shellSize.y, 1, 2));
    }

    private void addBottomLeftCorner(Region cornerRegion, Rectangle shellSize) {
        cornerRegion.add(new Rectangle(0 + shellSize.x, shellSize.height - 5 + shellSize.y, 1, 2));
        cornerRegion.add(new Rectangle(0 + shellSize.x, shellSize.height - 3 + shellSize.y, 2, 1));
        cornerRegion.add(new Rectangle(0 + shellSize.x, shellSize.height - 2 + shellSize.y, 3, 1));
        cornerRegion.add(new Rectangle(0 + shellSize.x, shellSize.height - 1 + shellSize.y, 5, 1));
    }

    public boolean close() {
        if (this.getShell() == null) {
            return super.close();
        }
        if (this.roundRegion != null) {
            this.roundRegion.dispose();
        }
        if (this.controlListener != null) {
            this.getParentShell().removeControlListener(this.controlListener);
            this.owner.removeControlListener(this.controlListener);
        }
        Region shellRegion = this.getShell().getRegion();
        this.getShell().setRegion(null);
        if (shellRegion != null) {
            shellRegion.dispose();
        }
        return super.close();
    }
}

