/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.ActivityManagerFactory;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.activities.ProxyActivityManager;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class WorkbenchActivitySupport
implements IWorkbenchActivitySupport {
    private IMutableActivityManager mutableActivityManager = ActivityManagerFactory.getMutableActivityManager();
    private ProxyActivityManager proxyActivityManager = new ProxyActivityManager(this.mutableActivityManager);

    public WorkbenchActivitySupport() {
        this.mutableActivityManager.addActivityManagerListener(new IActivityManagerListener(){
            private Set lastEnabled;
            {
                this.lastEnabled = new HashSet(WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds());
            }

            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                Set activityIds = WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds();
                if (!activityIds.equals(this.lastEnabled)) {
                    this.lastEnabled = new HashSet(activityIds);
                    IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        if (windows[i] instanceof WorkbenchWindow) {
                            WorkbenchWindow window = (WorkbenchWindow)windows[i];
                            WorkbenchJob job = new WorkbenchJob(this, window.getShell().getDisplay(), ActivityMessages.getString("ManagerJob"), window){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ WorkbenchWindow val$window;
                                {
                                    this.this$1 = var1_1;
                                    this.val$window = workbenchWindow;
                                }

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MenuManager manager = this.val$window.getMenuBarManager();
                                    if (manager != null) {
                                        manager.update(true);
                                    }
                                    if ((manager = this.val$window.getCoolBarManager()) != null) {
                                        manager.update(true);
                                    }
                                    if ((manager = this.val$window.getToolBarManager()) != null) {
                                        manager.update(true);
                                    }
                                    if ((manager = this.val$window.getStatusLineManager()) != null) {
                                        manager.update(true);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public IActivityManager getActivityManager() {
        return this.proxyActivityManager;
    }

    public void setEnabledActivityIds(Set enabledActivityIds) {
        this.mutableActivityManager.setEnabledActivityIds(enabledActivityIds);
    }
}

