/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.intro.IntroRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class IntroRegistryReader
extends RegistryReader {
    private static final String TAG_INTRO = "intro";
    private static final String TAG_INTROPRODUCTBINDING = "introProductBinding";
    private IntroRegistry introRegistry;

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_INTRO)) {
            this.readIntro(element);
            return true;
        }
        if (element.getName().equals(TAG_INTROPRODUCTBINDING)) {
            this.readBinding(element);
            return true;
        }
        return false;
    }

    private void readBinding(IConfigurationElement element) {
        try {
            this.introRegistry.addBinding(element);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(IntroMessages.getString("Intro.could_not_create_binding"), e.getStatus());
        }
    }

    private void readIntro(IConfigurationElement element) {
        try {
            IntroDescriptor descriptor = new IntroDescriptor(element);
            this.introRegistry.add(descriptor);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log(IntroMessages.getString("Intro.could_not_create_descriptor"), e.getStatus());
        }
    }

    public void readIntros(IExtensionRegistry in, IntroRegistry out) {
        this.introRegistry = out;
        this.readRegistry(in, "org.eclipse.ui", TAG_INTRO);
    }
}

