/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.progress.AwaitingFeedbackInfo;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class ProgressFeedbackDialog
extends Dialog {
    private IStructuredContentProvider provider;
    ListViewer viewer;

    public ProgressFeedbackDialog(IStructuredContentProvider contentProvider) {
        super(null);
        this.provider = contentProvider;
        this.setShellStyle(2144);
    }

    private ILabelProvider getLabelProvider() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((AwaitingFeedbackInfo)element).getMessage();
            }
        };
        return labelProvider;
    }

    public void refreshViewer() {
        this.viewer.refresh(true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ProgressMessages.getString("ProgressFeedbackDialog.DialogTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setBlockOnOpen(false);
        Composite mainArea = (Composite)super.createDialogArea(parent);
        this.viewer = new ListViewer(mainArea, 2048);
        GridData data = new GridData(1808);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        data.heightHint = this.convertVerticalDLUsToPixels(100);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setInput((Object)ProgressManager.getInstance().getFeedbackManager());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection structured;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() > 0) {
                    AwaitingFeedbackInfo info = (AwaitingFeedbackInfo)structured.getFirstElement();
                    info.getJob().schedule();
                }
            }
        });
        return mainArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

