/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.Hashtable;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.StyledTextRenderer;
import org.eclipse.swt.custom.WrappedContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class PrintRenderer
extends StyledTextRenderer {
    StyledTextContent logicalContent;
    WrappedContent content;
    Rectangle clientArea;
    GC gc;
    Hashtable lineBackgrounds;
    Hashtable lineStyles;
    Hashtable bidiSegments;

    PrintRenderer(Device device, Font regularFont, GC gc, StyledTextContent logicalContent, Hashtable lineBackgrounds, Hashtable lineStyles, Hashtable bidiSegments, int tabLength, Rectangle clientArea) {
        super(device, regularFont);
        this.logicalContent = logicalContent;
        this.lineBackgrounds = lineBackgrounds;
        this.lineStyles = lineStyles;
        this.bidiSegments = bidiSegments;
        this.clientArea = clientArea;
        this.gc = gc;
        this.calculateLineHeight();
        this.setTabLength(tabLength);
        this.content = new WrappedContent(this, logicalContent);
        this.content.wrapLines();
    }

    protected void dispose() {
        this.content = null;
        super.dispose();
    }

    protected void disposeGC(GC gc) {
    }

    protected void drawLineBreakSelection(String line, int lineOffset, int paintX, int paintY, GC gc) {
    }

    protected int[] getBidiSegments(int lineOffset, String lineText) {
        int lineLength = lineText.length();
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        int[] segments = (int[])this.bidiSegments.get(new Integer(logicalLineOffset));
        if (segments == null) {
            int[] nArray = new int[2];
            nArray[1] = lineLength;
            segments = nArray;
        } else {
            int logicalLineIndex = this.logicalContent.getLineAtOffset(lineOffset);
            int logicalLineLength = this.logicalContent.getLine(logicalLineIndex).length();
            if (lineOffset != logicalLineOffset || lineLength != logicalLineLength) {
                int lineOffsetDelta = lineOffset - logicalLineOffset;
                int newSegmentCount = 0;
                int[] newSegments = new int[segments.length];
                int i = 0;
                while (i < segments.length) {
                    newSegments[i] = Math.max(0, segments[i] - lineOffsetDelta);
                    if (newSegments[i] > lineLength) {
                        newSegments[i] = lineLength;
                        ++newSegmentCount;
                        break;
                    }
                    if (i == 0 || newSegments[i] > 0) {
                        ++newSegmentCount;
                    }
                    ++i;
                }
                segments = new int[newSegmentCount];
                i = 0;
                int newIndex = 0;
                while (i < newSegments.length && newIndex < newSegmentCount) {
                    if (i == 0 || newSegments[i] > 0) {
                        segments[newIndex++] = newSegments[i];
                    }
                    ++i;
                }
            }
        }
        return segments;
    }

    protected Rectangle getClientArea() {
        return this.clientArea;
    }

    protected StyledTextContent getContent() {
        return this.content;
    }

    protected GC getGC() {
        return this.gc;
    }

    protected int getHorizontalPixel() {
        return 0;
    }

    private int getLogicalLineOffset(int visualLineOffset) {
        int logicalLineIndex = this.logicalContent.getLineAtOffset(visualLineOffset);
        return this.logicalContent.getOffsetAtLine(logicalLineIndex);
    }

    protected int getOrientation() {
        return 0x2000000;
    }

    protected Color getSelectionBackground() {
        return null;
    }

    protected Color getSelectionForeground() {
        return null;
    }

    protected StyledTextEvent getLineBackgroundData(int lineOffset, String line) {
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        return (StyledTextEvent)this.lineBackgrounds.get(new Integer(logicalLineOffset));
    }

    protected StyledTextEvent getLineStyleData(int lineOffset, String line) {
        int logicalLineOffset = this.getLogicalLineOffset(lineOffset);
        StyledTextEvent logicalLineEvent = (StyledTextEvent)this.lineStyles.get(new Integer(logicalLineOffset));
        if (logicalLineEvent != null) {
            StyledTextEvent clone = new StyledTextEvent((StyledTextContent)logicalLineEvent.data);
            clone.detail = logicalLineEvent.detail;
            clone.styles = logicalLineEvent.styles;
            clone.text = logicalLineEvent.text;
            logicalLineEvent = this.getLineStyleData(clone, lineOffset, line);
        }
        return logicalLineEvent;
    }

    protected Point getSelection() {
        return new Point(0, 0);
    }

    protected boolean getWordWrap() {
        return true;
    }

    protected boolean isFullLineSelection() {
        return false;
    }
}

