/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        int[] scrap;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if (OS.GetCurrentScrap((int[])(scrap = new int[1])) != 0) {
            return null;
        }
        int[] typeIds = transfer.getTypeIds();
        int[] size = new int[1];
        int i = 0;
        while (i < typeIds.length) {
            byte[] buffer;
            int type = typeIds[i];
            size[0] = 0;
            if (OS.GetScrapFlavorSize((int)scrap[0], (int)type, (int[])size) == 0 && size[0] > 0 && OS.GetScrapFlavorData((int)scrap[0], (int)type, (int[])size, (byte[])(buffer = new byte[size[0]])) == 0) {
                TransferData tdata = new TransferData();
                tdata.type = type;
                tdata.data = new byte[1][];
                tdata.data[0] = buffer;
                return transfer.nativeToJava(tdata);
            }
            ++i;
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        int[] scrap;
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        if (OS.ClearCurrentScrap() != 0) {
            DND.error(2002);
        }
        if (OS.GetCurrentScrap((int[])(scrap = new int[1])) != 0) {
            DND.error(2002);
        }
        int i = 0;
        while (i < dataTypes.length) {
            int[] typeIds = dataTypes[i].getTypeIds();
            int j = 0;
            while (j < typeIds.length) {
                byte[] datum;
                TransferData transferData = new TransferData();
                transferData.type = typeIds[j];
                dataTypes[i].javaToNative(data[i], transferData);
                if (transferData.result != 0) {
                    DND.error(2002);
                }
                if (OS.PutScrapFlavor((int)scrap[0], (int)transferData.type, (int)0, (int)(datum = transferData.data[0]).length, (byte[])datum) != 0) {
                    DND.error(2002);
                }
                ++j;
            }
            ++i;
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        TransferData[] result = new TransferData[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = new TransferData();
            result[i].type = types[i];
            ++i;
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        int[] types = this._getAvailableTypes();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            StringBuffer sb = new StringBuffer();
            sb.append((char)((type & 0xFF000000) >> 24));
            sb.append((char)((type & 0xFF0000) >> 16));
            sb.append((char)((type & 0xFF00) >> 8));
            sb.append((char)((type & 0xFF) >> 0));
            names[i] = sb.toString();
            ++i;
        }
        return names;
    }

    private int[] _getAvailableTypes() {
        int[] types = new int[]{};
        int[] scrap = new int[1];
        if (OS.GetCurrentScrap((int[])scrap) != 0) {
            return types;
        }
        int[] count = new int[1];
        if (OS.GetScrapFlavorCount((int)scrap[0], (int[])count) != 0 || count[0] == 0) {
            return types;
        }
        int[] info = new int[count[0] * 2];
        if (OS.GetScrapFlavorInfoList((int)scrap[0], (int[])count, (int[])info) != 0) {
            return types;
        }
        types = new int[count[0]];
        int i = 0;
        while (i < count[0]) {
            types[i] = info[i * 2];
            ++i;
        }
        return types;
    }
}

