/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private TreeItem currentItem = null;
    private int currentEffect = 0;
    private TreeItem[] selection = new TreeItem[0];

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
    }

    void show(int effect, int x, int y) {
        TreeItem item = null;
        if (effect != 0) {
            item = this.findItem(x, y);
        }
        if (item == null) {
            effect = 0;
        }
        if (this.currentEffect != effect && this.currentEffect == 0) {
            this.selection = this.tree.getSelection();
            this.tree.setSelection(new TreeItem[0]);
        }
        boolean restoreSelection = this.currentEffect != effect && effect == 0;
        this.setDragUnderEffect(effect, item);
        if (restoreSelection) {
            this.tree.setSelection(this.selection);
            this.selection = new TreeItem[0];
        }
    }

    private TreeItem findItem(int x, int y) {
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        return this.tree.getItem(coordinates);
    }

    private void setDragUnderEffect(int effect, TreeItem item) {
        switch (effect) {
            case 1: {
                if (this.currentEffect == 4 || this.currentEffect == 2) {
                    this.setInsertMark(null, false);
                    this.currentEffect = 0;
                    this.currentItem = null;
                }
                if (this.currentEffect == effect && this.currentItem == item) break;
                this.setDropSelection(item);
                this.currentEffect = 1;
                this.currentItem = item;
                break;
            }
            case 2: 
            case 4: {
                if (this.currentEffect == 1) {
                    this.setDropSelection(null);
                    this.currentEffect = 0;
                    this.currentItem = null;
                }
                if (this.currentEffect == effect && this.currentItem == item) break;
                this.setInsertMark(item, effect == 4);
                this.currentEffect = effect;
                this.currentItem = item;
                break;
            }
            default: {
                if (this.currentEffect == 4 || this.currentEffect == 2) {
                    this.setInsertMark(null, false);
                }
                if (this.currentEffect == 1) {
                    this.setDropSelection(null);
                }
                this.currentEffect = 0;
                this.currentItem = null;
            }
        }
    }

    private void setDropSelection(TreeItem item) {
        if (item == null) {
            this.tree.setSelection(new TreeItem[0]);
        } else {
            this.tree.setSelection(new TreeItem[]{item});
        }
    }

    private void setInsertMark(TreeItem item, boolean after) {
    }
}

