/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget() {
        super.createWidget();
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int parentHandle = this.parent.handle;
        if (!this.parent.isDrawing(parentHandle)) {
            return false;
        }
        int nWidth = this.width;
        int nHeight = this.height;
        if (nWidth <= 0) {
            nWidth = 1;
        }
        int window = OS.GetControlOwner((int)parentHandle);
        int port = OS.GetWindowPort((int)window);
        int[] currentPort = new int[1];
        OS.GetPort((int[])currentPort);
        OS.SetPort((int)port);
        int oldClip = OS.NewRgn();
        int visibleRgn = this.parent.getVisibleRegion(parentHandle, true);
        OS.GetClip((int)oldClip);
        OS.SetClip((int)visibleRgn);
        Rect rect = new Rect();
        OS.GetControlBounds((int)parentHandle, (Rect)rect);
        int left = rect.left + this.x;
        int top = rect.top + this.y;
        if (this.image == null) {
            OS.SetRect((Rect)rect, (short)((short)left), (short)((short)top), (short)((short)(left + nWidth)), (short)((short)(top + nHeight)));
            RGBColor color = new RGBColor();
            color.red = (short)-1;
            color.green = (short)-1;
            color.blue = (short)-1;
            OS.RGBBackColor((RGBColor)color);
            OS.InvertRect((Rect)rect);
        } else {
            int imageHandle = this.image.handle;
            nWidth = OS.CGImageGetWidth((int)imageHandle);
            nHeight = OS.CGImageGetHeight((int)imageHandle);
            int bpl = OS.CGImageGetBytesPerRow((int)imageHandle);
            Rect bounds = new Rect();
            bounds.right = (short)nWidth;
            bounds.bottom = (short)nHeight;
            Rect portRect = new Rect();
            OS.GetWindowBounds((int)window, (short)33, (Rect)portRect);
            OS.SetRect((Rect)rect, (short)((short)(left += portRect.left)), (short)((short)(top += portRect.top)), (short)((short)(left + nWidth)), (short)((short)(top + nHeight)));
            int[] gWorld = new int[1];
            OS.NewGWorldFromPtr((int[])gWorld, (int)32, (Rect)bounds, (int)0, (int)0, (int)0, (int)this.image.data, (int)bpl);
            int[] curPort = new int[1];
            int[] curGWorld = new int[1];
            OS.GetGWorld((int[])curPort, (int[])curGWorld);
            OS.SetGWorld((int)gWorld[0], (int)curGWorld[0]);
            int portBitMap = OS.GetPortBitMapForCopyBits((int)port);
            int gworldBitMap = OS.GetPortBitMapForCopyBits((int)gWorld[0]);
            OS.OffsetRgn((int)visibleRgn, (short)portRect.left, (short)portRect.top);
            OS.CopyBits((int)gworldBitMap, (int)portBitMap, (Rect)bounds, (Rect)rect, (short)6, (int)visibleRgn);
            OS.OffsetRgn((int)visibleRgn, (short)(-portRect.left), (short)(-portRect.top));
            OS.SetGWorld((int)curPort[0], (int)curGWorld[0]);
            OS.DisposeGWorld((int)gWorld[0]);
        }
        OS.SetClip((int)oldClip);
        OS.DisposeRgn((int)visibleRgn);
        OS.DisposeRgn((int)oldClip);
        OS.SetPort((int)currentPort[0]);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Point(rect.width, rect.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseChild() {
        super.releaseChild();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        boolean isFocus = this.isFocusCaret();
        if (isFocus) {
            this.hideCaret();
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (isFocus) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean isFocus;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (isFocus = this.isFocusCaret()) {
            this.hideCaret();
        }
        this.image = image;
        if (isFocus) {
            this.showCaret();
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(this.x, this.y, width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

