/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.internal.carbon.FontInfo;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.MenuTrackingData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int handle;
    short id;
    int x;
    int y;
    boolean hasLocation;
    boolean modified;
    boolean closed;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    MenuItem lastTarget;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        if (!visible) {
            return;
        }
        int left = this.x;
        int top = this.y;
        if (!this.hasLocation) {
            Point where = new Point();
            OS.GetGlobalMouse((Point)where);
            left = where.h;
            top = where.v;
        }
        OS.PopUpMenuSelect((int)this.handle, (short)((short)top), (short)((short)left), (short)-1);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        int[] outMenuRef = new int[1];
        OS.CreateNewMenu((short)this.id, (int)0, (int[])outMenuRef);
        if (outMenuRef[0] == 0) {
            this.display.removeMenu(this);
            this.error(2);
        }
        this.handle = outMenuRef[0];
    }

    void createItem(MenuItem item, int index) {
        int result;
        this.checkWidget();
        short count = OS.CountMenuItems((int)this.handle);
        if (index < 0 || index > count) {
            this.error(6);
        }
        int attributes = 2560;
        if ((item.style & 2) != 0) {
            attributes = 64;
        }
        if ((result = OS.InsertMenuItemTextWithCFString((int)this.handle, (int)0, (short)((short)index), (int)attributes, (int)0)) != 0) {
            this.error(14);
        }
        if (count == this.items.length) {
            MenuItem[] newItems = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        this.modified = true;
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void destroyItem(MenuItem item) {
        int count = OS.CountMenuItems((int)this.handle);
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == count) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        this.items[count] = null;
        if (count == 0) {
            this.items = new MenuItem[4];
        }
        this.modified = true;
        OS.DeleteMenuItem((int)this.handle, (short)((short)(index + 1)));
    }

    void destroyWidget() {
        int theMenu = this.handle;
        this.releaseHandle();
        if (theMenu != 0) {
            OS.DeleteMenu((short)OS.GetMenuID((int)theMenu));
            OS.DisposeMenu((int)theMenu);
        }
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        short count = OS.CountMenuItems((int)this.handle);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.CountMenuItems((int)this.handle);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        short count = OS.CountMenuItems((int)this.handle);
        MenuItem[] result = new MenuItem[count];
        System.arraycopy(this.items, 0, result, 0, count);
        return result;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    org.eclipse.swt.graphics.Point getSize() {
        if ((this.style & 2) != 0) {
            int height = OS.GetMBarHeight();
            int gdevice = OS.GetMainDevice();
            int[] ptr = new int[1];
            OS.memcpy((int[])ptr, (int)gdevice, (int)4);
            GDevice device = new GDevice();
            OS.memcpy((GDevice)device, (int)ptr[0], (int)62);
            return new org.eclipse.swt.graphics.Point(device.right - device.left, height);
        }
        short width = OS.GetMenuWidth((int)this.handle);
        short height = OS.GetMenuHeight((int)this.handle);
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public boolean getVisible() {
        MenuTrackingData outData;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.GetMenuTrackingData((int)this.handle, (MenuTrackingData)(outData = new MenuTrackingData())) == 0;
    }

    void hookEvents() {
        super.hookEvents();
        int menuProc = this.display.menuProc;
        int[] mask = new int[]{1835363957, 5, 1835363957, 4, 1835363957, 6, 1835363957, 100, 1835363957, 103};
        int menuTarget = OS.GetMenuEventTarget((int)this.handle);
        OS.InstallEventHandler((int)menuTarget, (int)menuProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
    }

    int kEventMenuClosed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuClosed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.closed = true;
        this.sendEvent(23);
        return -9874;
    }

    int kEventMenuDrawItemContent(int nextHandler, int theEvent, int userData) {
        String accelText;
        int length;
        int accelIndex;
        short[] index = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1769235821, (int)1835623544, null, (int)2, null, (short[])index);
        MenuItem item = this.items[index[0] - 1];
        if (item.accelerator == 0 && (accelIndex = item.text.indexOf(9)) != -1 && (length = (accelText = item.text.substring(accelIndex + 1)).length()) != 0) {
            int result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
            Rect rect = new Rect();
            OS.GetEventParameter((int)theEvent, (int)1835627618, (int)1902408308, null, (int)8, null, (Rect)rect);
            int[] context = new int[1];
            OS.GetEventParameter((int)theEvent, (int)1668183160, (int)1668183160, null, (int)4, null, (int[])context);
            int modifierIndex = this.modifierIndex(accelText);
            char[] buffer = new char[length - modifierIndex - 1];
            accelText.getChars(modifierIndex + 1, length, buffer, 0);
            int font = 101;
            if (buffer.length > 1) {
                font = 103;
            }
            byte[] family = new byte[256];
            short[] size = new short[1];
            byte[] style = new byte[1];
            OS.GetThemeFont((short)((short)font), (short)-1, (byte[])family, (short[])size, (byte[])style);
            FontInfo info = new FontInfo();
            OS.FetchFontInfo((short)family[0], (short)size[0], (short)style[0], (FontInfo)info);
            int[] metric = new int[1];
            OS.GetThemeMetric((int)69, (int[])metric);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            Point size1 = new Point();
            OS.GetThemeTextDimensions((int)str, (short)((short)font), (int)0, (boolean)false, (Point)size1, null);
            rect.left = (short)(rect.right - Math.max(info.widMax, size1.h) - metric[0]);
            OS.DrawThemeTextBox((int)str, (short)((short)font), (int)1, (boolean)false, (Rect)rect, (short)-2, (int)context[0]);
            OS.CFRelease((int)str);
            if (modifierIndex != -1) {
                buffer = new char[modifierIndex + 1];
                accelText.getChars(0, buffer.length, buffer, 0);
                str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
                OS.GetThemeTextDimensions((int)str, (short)103, (int)0, (boolean)false, (Point)size1, null);
                rect.right = rect.left;
                rect.left = (short)(rect.right - size1.h);
                OS.DrawThemeTextBox((int)str, (short)103, (int)1, (boolean)false, (Rect)rect, (short)-2, (int)context[0]);
                OS.CFRelease((int)str);
            }
            return result;
        }
        return -9874;
    }

    int kEventMenuMeasureItemWidth(int nextHandler, int theEvent, int userData) {
        String accelText;
        int accelIndex;
        short[] index = new short[1];
        OS.GetEventParameter((int)theEvent, (int)1769235821, (int)1835623544, null, (int)2, null, (short[])index);
        MenuItem item = this.items[index[0] - 1];
        if (item.accelerator == 0 && (accelIndex = item.text.indexOf(9)) != -1 && (accelText = item.text.substring(accelIndex + 1)).length() != 0) {
            int result = OS.CallNextEventHandler((int)nextHandler, (int)theEvent);
            char[] buffer = new char[accelText.length()];
            accelText.getChars(0, buffer.length, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)buffer.length);
            Point size = new Point();
            OS.GetThemeTextDimensions((int)str, (short)103, (int)0, (boolean)false, (Point)size, null);
            OS.CFRelease((int)str);
            short[] width = new short[1];
            OS.GetEventParameter((int)theEvent, (int)1835627639, (int)1936224114, null, (int)2, null, (short[])width);
            int[] metric = new int[1];
            OS.GetThemeMetric((int)67, (int[])metric);
            width[0] = (short)(width[0] + (metric[0] + size.h));
            OS.SetEventParameter((int)theEvent, (int)1835627639, (int)1936224114, (int)2, (short[])width);
            return result;
        }
        return -9874;
    }

    int kEventMenuOpening(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuOpening(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.closed = false;
        this.sendEvent(22);
        this.modified = false;
        return -9874;
    }

    int kEventMenuTargetItem(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMenuTargetItem(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.lastTarget = null;
        short[] index = new short[1];
        if (OS.GetEventParameter((int)theEvent, (int)1769235821, (int)1835623544, null, (int)2, null, (short[])index) == 0) {
            if (index[0] != 0) {
                this.lastTarget = this.items[index[0] - 1];
            }
            if (this.lastTarget != null) {
                this.lastTarget.sendEvent(30);
            }
        }
        return -9874;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int count = OS.CountMenuItems((int)this.handle);
        int i = 0;
        while (i < count) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int modifierIndex(String accelText) {
        int start;
        int index = start = accelText.length() - 1;
        while (index >= 0) {
            char c = accelText.charAt(index);
            switch (c) {
                case ' ': {
                    if (index == start) break;
                    return index;
                }
                case '\u21e7': 
                case '\u2303': 
                case '\u2318': 
                case '\u2325': {
                    return index;
                }
            }
            --index;
        }
        return -1;
    }

    void releaseChild() {
        super.releaseChild();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        int count = OS.CountMenuItems((int)this.handle);
        int i = 0;
        while (i < count) {
            MenuItem item = this.items[i];
            if (!item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.lastTarget = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            this.state &= 0xFFFFFFF7;
            OS.EnableMenuItem((int)this.handle, (short)0);
        } else {
            this.state |= 8;
            OS.DisableMenuItem((int)this.handle, (short)0);
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }
}

